/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.legendofdragoon.scripting.tokens.Data;
import org.legendofdragoon.scripting.tokens.Entry;
import org.legendofdragoon.scripting.tokens.Entrypoint;
import org.legendofdragoon.scripting.tokens.LodString;
import org.legendofdragoon.scripting.tokens.Op;
import org.legendofdragoon.scripting.tokens.Param;
import org.legendofdragoon.scripting.tokens.PointerTable;
import org.legendofdragoon.scripting.tokens.Script;

public class Compiler {
    public int[] compile(Script script) {
        int[] out = new int[script.entries.length];
        for (int entryIndex = 0; entryIndex < script.entries.length; ++entryIndex) {
            Entry entry = script.entries[entryIndex];
            if (entry instanceof Entrypoint) {
                Entrypoint entrypoint = (Entrypoint)entry;
                out[entryIndex] = this.findEntrypointAddress(script, entrypoint);
                continue;
            }
            if (entry instanceof Data) {
                Data data = (Data)entry;
                out[entryIndex] = data.value;
                continue;
            }
            if (entry instanceof LodString) {
                LodString data = (LodString)entry;
                for (int i = 0; i < data.chars.length; i += 2) {
                    out[entryIndex] = data.chars[i];
                    if (i + 1 < data.chars.length) {
                        int n = entryIndex;
                        out[n] = out[n] | data.chars[i + 1] << 16;
                    }
                    ++entryIndex;
                }
                --entryIndex;
                continue;
            }
            if (entry instanceof PointerTable) {
                PointerTable rel = (PointerTable)entry;
                if (rel.labels.length == 0) {
                    throw new RuntimeException("Empty pointer table at 0x%x".formatted(rel.address));
                }
                for (String label : rel.labels) {
                    int destAddress = this.findLabelAddress(script, label);
                    out[entryIndex++] = (destAddress - rel.address) / 4;
                }
                --entryIndex;
                continue;
            }
            if (entry instanceof Op) {
                Op op = (Op)entry;
                out[entryIndex] = op.type.opcode | op.params.length << 8 | op.headerParam << 16;
                for (Param param : op.params) {
                    for (int i = 0; i < param.type.width; ++i) {
                        out[++entryIndex] = param.rawValues[i];
                    }
                }
                continue;
            }
            throw new RuntimeException("Unknown entry " + entry.getClass().getSimpleName() + " at index " + entryIndex);
        }
        return out;
    }

    private int findEntrypointAddress(Script script, Entrypoint entrypoint) {
        return this.findLabelAddress(script, entrypoint.destination);
    }

    private int findLabelAddress(Script script, String label) {
        Optional<Map.Entry> opt = script.labels.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(label)).findFirst();
        if (opt.isEmpty()) {
            throw new RuntimeException("Couldn't find label destination " + label);
        }
        return (Integer)opt.get().getKey();
    }
}

