/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.legendofdragoon.modloader.events.EventManager;
import org.legendofdragoon.modloader.events.registries.RegistryEvent;
import org.legendofdragoon.modloader.registries.MutableRegistry;
import org.legendofdragoon.modloader.registries.Registry;
import org.legendofdragoon.modloader.registries.RegistryEntry;

public class Registries {
    private final EventManager events;
    private final List<MutableRegistry<?>> registries = new ArrayList();
    private final Map<MutableRegistry<?>, Function<MutableRegistry<?>, RegistryEvent.Register<?>>> registryEvents = new HashMap();

    protected Registries(EventManager events, Consumer<Access> access) {
        this.events = events;
        access.accept(new Access());
    }

    protected <Type extends RegistryEntry> Registry<Type> addRegistry(Registry<Type> registry, Function<MutableRegistry<Type>, RegistryEvent.Register<Type>> registryEvent) {
        MutableRegistry mutableRegistry = (MutableRegistry)registry;
        this.registries.add(mutableRegistry);
        this.registryEvents.put(mutableRegistry, registryEvent);
        return registry;
    }

    public class Access {
        private final Set<Registry<?>> initialized = new HashSet();

        private Access() {
        }

        public <T extends RegistryEntry> void initialize(Registry<?> registry) {
            if (this.initialized.contains(registry)) {
                throw new IllegalStateException("Registry " + String.valueOf(registry) + " already initialized");
            }
            MutableRegistry mutableRegistry = (MutableRegistry)registry;
            if (!Registries.this.registryEvents.containsKey(mutableRegistry)) {
                throw new IllegalArgumentException("Unknown registry " + String.valueOf(registry));
            }
            Registries.this.events.postEvent(Registries.this.registryEvents.get(mutableRegistry).apply(mutableRegistry));
            mutableRegistry.lock();
            this.initialized.add(mutableRegistry);
        }

        public void initializeRemaining() {
            for (MutableRegistry<?> registry : Registries.this.registries) {
                if (this.initialized.contains(registry)) continue;
                this.initialize(registry);
            }
        }

        public void reset() {
            this.initialized.clear();
            for (MutableRegistry<?> registry : Registries.this.registries) {
                registry.reset();
            }
        }
    }
}

