/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader.i18n;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.legendofdragoon.modloader.ModContainer;
import org.legendofdragoon.modloader.ModManager;

public class LangManager {
    private static final Logger LOGGER = LogManager.getFormatterLogger(LangManager.class);
    private final Map<String, String> translations = new HashMap<String, String>();

    public LangManager(Consumer<Access> access) {
        access.accept(new Access());
    }

    public String getTranslation(String key) {
        return this.translations.getOrDefault(key, key).formatted(new Object[0]);
    }

    public String getTranslation(String key, Object ... args) {
        return this.translations.getOrDefault(key, key).formatted(args);
    }

    public class Access {
        private Access() {
        }

        public void initialize(ModManager mods, Locale locale) {
            for (ModContainer mod : mods.getLoadedMods()) {
                try {
                    LangManager.this.translations.putAll(mod.loadLang(locale));
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to load %s for mod %d", (Object)locale, (Object)mod.modId);
                }
            }
        }

        public void reset() {
            LangManager.this.translations.clear();
        }
    }
}

