/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader.events;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.legendofdragoon.modloader.ModManager;
import org.legendofdragoon.modloader.events.Event;
import org.legendofdragoon.modloader.events.EventListener;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class EventManager {
    private static final Logger LOGGER = LogManager.getFormatterLogger(EventManager.class);
    private final Map<Consumer<Event>, Class<?>> listeners = new ConcurrentHashMap();
    private final Set<Consumer<Event>> staleListeners = Collections.synchronizedSet(new HashSet());

    public EventManager(Consumer<Access> access) {
        access.accept(new Access());
    }

    private void register(Class<?> listener, @Nullable Object instance) {
        for (final Method method : listener.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(EventListener.class)) continue;
            if (!method.canAccess(instance)) {
                LOGGER.warn("Event listener %s must be static", listener);
                continue;
            }
            if (method.getParameterCount() != 1) {
                LOGGER.warn("Event listener %s must have one parameter", listener);
                continue;
            }
            if (!Event.class.isAssignableFrom(method.getParameters()[0].getType())) {
                LOGGER.warn("Event listener %s must have event parameter", listener);
                continue;
            }
            if (instance == null) {
                this.listeners.put(event -> {
                    try {
                        method.invoke(null, event);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        LOGGER.error("Failed to deliver event", (Throwable)e);
                    }
                }, method.getParameters()[0].getType());
                continue;
            }
            final WeakReference<Object> ref = new WeakReference<Object>(instance);
            this.listeners.put(new Consumer<Event>(){

                @Override
                public void accept(Event event) {
                    if (ref.get() == null) {
                        EventManager.this.staleListeners.add(this);
                    } else {
                        try {
                            method.invoke(ref.get(), event);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            LOGGER.error("Failed to deliver event", (Throwable)e);
                        }
                    }
                }
            }, method.getParameters()[0].getType());
        }
    }

    public void register(Object listener) {
        this.register(listener.getClass(), listener);
    }

    public <T extends Event> T postEvent(T event) {
        for (Map.Entry<Consumer<Event>, Class<?>> entry : this.listeners.entrySet()) {
            if (!entry.getValue().isInstance(event)) continue;
            entry.getKey().accept(event);
        }
        return event;
    }

    public void clearStaleRefs() {
        this.listeners.keySet().removeAll(this.staleListeners);
        this.staleListeners.clear();
    }

    public class Access {
        private Access() {
        }

        public void initialize(ModManager mods) {
            LOGGER.info("Scanning for event consumers...");
            ConfigurationBuilder config = new ConfigurationBuilder().addClassLoaders(new ClassLoader[]{this.getClass().getClassLoader()}).addUrls(ClasspathHelper.forPackage((String)"legend", (ClassLoader[])new ClassLoader[0]));
            Reflections reflections = new Reflections((Configuration)mods.addModsToReflectionsConfig(config));
            Set listeners = reflections.getTypesAnnotatedWith(EventListener.class);
            for (Class listener : listeners) {
                EventManager.this.register(listener, null);
            }
        }

        public void reset() {
            EventManager.this.listeners.clear();
            EventManager.this.staleListeners.clear();
        }
    }
}

