/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.kernel.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.ldp4j.application.data.constraints.Constraints;
import org.ldp4j.application.engine.context.HttpRequest;
import org.ldp4j.application.kernel.constraints.ConstraintReport;
import org.ldp4j.application.kernel.constraints.ConstraintReportId;
import org.ldp4j.application.kernel.impl.AbstractInMemoryResource;
import org.ldp4j.application.kernel.impl.AttachmentId;
import org.ldp4j.application.kernel.impl.InMemoryConstraintReport;
import org.ldp4j.application.kernel.impl.InMemoryContainer;
import org.ldp4j.application.kernel.resource.Attachment;
import org.ldp4j.application.kernel.resource.Resource;
import org.ldp4j.application.kernel.resource.ResourceId;
import org.ldp4j.application.kernel.resource.ResourceVisitor;
import org.ldp4j.application.kernel.resource.Resources;
import org.ldp4j.application.kernel.template.ResourceTemplate;
import org.ldp4j.application.kernel.template.TemplateIntrospector;

class InMemoryResource
extends AbstractInMemoryResource
implements Resource {
    private final Map<AttachmentId, InMemoryAttachment> attachments;
    private final Map<String, AttachmentId> attachmentsById;
    private final Map<ResourceId, AttachmentId> attachmentsByResourceId;
    private final VersionGenerator versionGenerator;
    private final Map<String, ConstraintReportId> reports;
    private final ResourceId id;
    private final ResourceId parentId;
    private URI indirectId;

    protected InMemoryResource(ResourceId id, ResourceId parentId) {
        this.id = id;
        this.parentId = parentId;
        this.attachments = new LinkedHashMap<AttachmentId, InMemoryAttachment>();
        this.attachmentsById = new LinkedHashMap<String, AttachmentId>();
        this.attachmentsByResourceId = new LinkedHashMap<ResourceId, AttachmentId>();
        this.versionGenerator = new VersionGenerator();
        this.reports = Maps.newLinkedHashMap();
    }

    protected InMemoryResource(ResourceId id) {
        this(id, null);
    }

    protected final InMemoryResource createChild(ResourceId resourceId, ResourceTemplate template) {
        InMemoryResource newResource = null;
        newResource = !TemplateIntrospector.newInstance((ResourceTemplate)template).isContainer() ? new InMemoryResource(resourceId, this.id) : new InMemoryContainer(resourceId, this.id);
        newResource.setTemplateLibrary(this.getTemplateLibrary());
        return newResource;
    }

    private synchronized ConstraintReportId nextConstraintReportId() {
        String failureId = null;
        while (this.reports.containsKey(failureId = UUID.randomUUID().toString())) {
        }
        ConstraintReportId reportId = ConstraintReportId.create((ResourceId)this.id, (String)failureId);
        this.reports.put(failureId, reportId);
        return reportId;
    }

    public ResourceId id() {
        return this.id;
    }

    public void setIndirectId(URI indirectId) {
        this.indirectId = indirectId;
    }

    public URI indirectId() {
        return this.indirectId;
    }

    public boolean isRoot() {
        return this.parentId == null;
    }

    public ResourceId parentId() {
        return this.parentId;
    }

    public Attachment findAttachment(ResourceId resourceId) {
        Preconditions.checkNotNull((Object)resourceId, (Object)"Attached resource identifier cannot be null");
        return this.attachments.get(this.attachmentsByResourceId.get(resourceId));
    }

    public Resource attach(String attachmentId, ResourceId resourceId) {
        return this.attach(attachmentId, resourceId, Resource.class);
    }

    public <T extends Resource> T attach(String attachmentId, ResourceId resourceId, Class<? extends T> clazz) {
        Preconditions.checkNotNull((Object)attachmentId, (Object)"Attachment identifier cannot be null");
        Preconditions.checkNotNull((Object)resourceId, (Object)"Attached resource identifier cannot be null");
        Preconditions.checkNotNull(clazz, (Object)"Attached resource class cannot be null");
        AttachmentId aId = AttachmentId.createId(attachmentId, resourceId);
        Preconditions.checkState((!this.attachments.containsKey(aId) ? 1 : 0) != 0, (String)"Resource '%s' is already attached as '%s'", (Object[])new Object[]{resourceId, attachmentId});
        Preconditions.checkState((!this.attachmentsById.containsKey(attachmentId) ? 1 : 0) != 0, (String)"A resource is already attached as '%s'", (Object[])new Object[]{attachmentId});
        Preconditions.checkState((!this.attachmentsByResourceId.containsKey(resourceId) ? 1 : 0) != 0, (String)"Resource '%s' is already attached", (Object[])new Object[]{resourceId});
        ResourceTemplate attachmentTemplate = super.getTemplate(resourceId);
        Preconditions.checkState((boolean)Resources.areCompatible(clazz, (ResourceTemplate)attachmentTemplate), (String)"Attachment '%s' is not of type '%s' (%s)", (Object[])new Object[]{attachmentId, clazz.getCanonicalName(), attachmentTemplate.getClass().getCanonicalName()});
        InMemoryResource newResource = this.createChild(resourceId, attachmentTemplate);
        InMemoryAttachment newAttachment = new InMemoryAttachment(aId, this.versionGenerator.nextVersion(attachmentId));
        this.attachments.put(newAttachment.attachmentId(), newAttachment);
        this.attachmentsById.put(aId.id(), aId);
        this.attachmentsByResourceId.put(aId.resourceId(), aId);
        return (T)((Resource)clazz.cast(newResource));
    }

    public boolean detach(Attachment attachment) {
        boolean found = this.attachments.containsValue(attachment);
        if (found) {
            AttachmentId remove = this.attachmentsById.remove(attachment.id());
            this.attachmentsByResourceId.remove(attachment.resourceId());
            this.attachments.remove(remove);
        }
        return found;
    }

    public Set<InMemoryAttachment> attachments() {
        return Collections.unmodifiableSet(new LinkedHashSet<InMemoryAttachment>(this.attachments.values()));
    }

    public void accept(ResourceVisitor visitor) {
        visitor.visitResource((Resource)this);
    }

    public ConstraintReport addConstraintReport(Constraints constraints, Date date, HttpRequest request) {
        ConstraintReportId reportId = this.nextConstraintReportId();
        return new InMemoryConstraintReport(reportId, date, request, constraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ConstraintReportId> constraintReports() {
        ImmutableSet currentReports = null;
        InMemoryResource inMemoryResource = this;
        synchronized (inMemoryResource) {
            currentReports = ImmutableSet.copyOf(this.reports.values());
        }
        return currentReports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFailure(ConstraintReport report) {
        if (report != null) {
            String failureId = report.id().failureId();
            InMemoryResource inMemoryResource = this;
            synchronized (inMemoryResource) {
                this.reports.remove(failureId);
            }
        }
    }

    public String toString() {
        return this.stringHelper().toString();
    }

    @Override
    protected MoreObjects.ToStringHelper stringHelper() {
        return super.stringHelper().add("id", (Object)this.id).add("parentId", (Object)this.parentId).add("attachments", this.attachments);
    }

    private static final class InMemoryAttachment
    implements Attachment {
        private final AttachmentId attachmentId;
        private final long version;

        private InMemoryAttachment(AttachmentId attachmentId, long version) {
            this.attachmentId = attachmentId;
            this.version = version;
        }

        private AttachmentId attachmentId() {
            return this.attachmentId;
        }

        public String id() {
            return this.attachmentId.id();
        }

        public ResourceId resourceId() {
            return this.attachmentId.resourceId();
        }

        public long version() {
            return this.version;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("id", (Object)this.id()).add("resourceId", (Object)this.resourceId()).add("version", this.version).toString();
        }
    }

    private static final class VersionGenerator {
        private final ConcurrentMap<String, AtomicLong> attachmentCounter = new ConcurrentHashMap<String, AtomicLong>();

        private VersionGenerator() {
        }

        long nextVersion(String id) {
            AtomicLong counter = this.attachmentCounter.putIfAbsent(id, new AtomicLong(-1L));
            if (counter == null) {
                counter = (AtomicLong)this.attachmentCounter.get(id);
            }
            return counter.incrementAndGet();
        }
    }
}

