/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.kernel.impl;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.engine.context.EntityTag;
import org.ldp4j.application.kernel.endpoint.Endpoint;
import org.ldp4j.application.kernel.impl.InMemoryContainer;
import org.ldp4j.application.kernel.impl.InMemoryEndpoint;
import org.ldp4j.application.kernel.impl.InMemoryResource;
import org.ldp4j.application.kernel.resource.Resource;
import org.ldp4j.application.kernel.resource.ResourceId;
import org.ldp4j.application.kernel.spi.ModelFactory;
import org.ldp4j.application.kernel.template.ContainerTemplate;
import org.ldp4j.application.kernel.template.ResourceTemplate;
import org.ldp4j.application.kernel.template.SimpleTemplateVisitor;
import org.ldp4j.application.kernel.template.TemplateLibrary;
import org.ldp4j.application.kernel.template.TemplateVisitor;

final class InMemoryModelFactory
implements ModelFactory {
    private TemplateLibrary templateLibrary;

    InMemoryModelFactory() {
    }

    public void useTemplates(TemplateLibrary library) {
        this.templateLibrary = library;
    }

    public Resource createResource(ResourceTemplate template, Name<?> name) {
        Preconditions.checkNotNull(name, (Object)"Resource name cannot be null");
        Preconditions.checkArgument((boolean)this.templateLibrary.contains(template), (Object)("Unknown template " + template));
        RootResourceCreator creator = new RootResourceCreator(ResourceId.createId(name, (ResourceTemplate)template));
        template.accept((TemplateVisitor)creator);
        return creator.createdResource();
    }

    public Endpoint createEndpoint(String path, Resource resource, Date created, EntityTag entityTag) {
        Preconditions.checkNotNull((Object)resource, (Object)"Resource cannot be null");
        return InMemoryEndpoint.create(path, resource.id(), created, entityTag);
    }

    private final class RootResourceCreator
    extends SimpleTemplateVisitor {
        private final ResourceId id;
        private InMemoryResource resource;

        private RootResourceCreator(ResourceId id) {
            this.id = id;
        }

        private InMemoryResource createdResource() {
            return this.resource;
        }

        private void createResource(InMemoryResource resource) {
            this.resource = resource;
            this.resource.setTemplateLibrary(InMemoryModelFactory.this.templateLibrary);
        }

        public void visitResourceTemplate(ResourceTemplate template) {
            this.createResource(new InMemoryResource(this.id, null));
        }

        public void visitContainerTemplate(ContainerTemplate template) {
            this.createResource(new InMemoryContainer(this.id, null));
        }
    }
}

