/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.kernel.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ldp4j.application.kernel.endpoint.Endpoint;
import org.ldp4j.application.kernel.endpoint.EndpointRepository;
import org.ldp4j.application.kernel.lifecycle.LifecycleException;
import org.ldp4j.application.kernel.lifecycle.Managed;
import org.ldp4j.application.kernel.resource.ResourceId;

final class InMemoryEndpointRepository
implements Managed,
EndpointRepository {
    private final Map<String, Endpoint> endpointsByPath = Maps.newLinkedHashMap();
    private final Map<ResourceId, Endpoint> endpointsByResourceName = Maps.newLinkedHashMap();
    private final Lock readLock;
    private final Lock writeLock;

    InMemoryEndpointRepository() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint endpointOfPath(String path) {
        this.readLock.lock();
        try {
            Endpoint endpoint = this.endpointsByPath.get(path);
            return endpoint;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint endpointOfResource(ResourceId id) {
        this.readLock.lock();
        try {
            Endpoint endpoint = this.endpointsByResourceName.get(id);
            if (endpoint != null && endpoint.deleted() != null) {
                endpoint = null;
            }
            Endpoint endpoint2 = endpoint;
            return endpoint2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Endpoint endpoint) {
        this.writeLock.lock();
        try {
            if (this.endpointsByPath.containsKey(endpoint.path())) {
                throw new IllegalArgumentException("An endpoint with path '" + endpoint.path() + "' already exists");
            }
            Endpoint other = this.endpointOfResource(endpoint.resourceId());
            if (other != null) {
                throw new IllegalArgumentException("An endpoint with resource name '" + endpoint.resourceId() + "' already exists (" + other + ")");
            }
            this.endpointsByPath.put(endpoint.path(), endpoint);
            this.endpointsByResourceName.put(endpoint.resourceId(), endpoint);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void init() throws LifecycleException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws LifecycleException {
        this.writeLock.lock();
        try {
            this.endpointsByPath.clear();
            this.endpointsByResourceName.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

