/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.kernel.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.ldp4j.application.engine.context.EntityTag;
import org.ldp4j.application.kernel.endpoint.Endpoint;
import org.ldp4j.application.kernel.resource.ResourceId;

final class InMemoryEndpoint
implements Endpoint {
    private final String path;
    private final Date created;
    private ResourceId resourceId;
    private EntityTag entityTag;
    private Date lastModified;
    private Date deleted;

    private InMemoryEndpoint(String path, ResourceId resourceId, Date created, EntityTag entityTag) {
        this.path = path;
        this.resourceId = resourceId;
        this.created = created;
        this.entityTag = entityTag;
        this.lastModified = created;
    }

    public String path() {
        return this.path;
    }

    public Date created() {
        return this.created;
    }

    public Date deleted() {
        return this.deleted;
    }

    public EntityTag entityTag() {
        return this.entityTag;
    }

    public Date lastModified() {
        return this.lastModified;
    }

    public ResourceId resourceId() {
        return this.resourceId;
    }

    public void modify(EntityTag newEntityTag, Date newLastModified) {
        Preconditions.checkState((this.deleted == null ? 1 : 0) != 0, (Object)"Endpoint is already deleted");
        this.entityTag = newEntityTag;
        this.lastModified = new Date(newLastModified.getTime());
    }

    public void delete(Date deleted) {
        Preconditions.checkState((this.deleted == null ? 1 : 0) != 0, (Object)"Endpoint is already deleted");
        this.deleted = deleted;
        this.resourceId = null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("path", (Object)this.path).add("created", (Object)this.created).add("deleted", (Object)this.deleted).add("entityTag", (Object)this.entityTag).add("lastModified", this.lastModified.getTime()).add("resourceId", (Object)this.resourceId).toString();
    }

    static InMemoryEndpoint create(String path, ResourceId resourceId, Date created, EntityTag entityTag) {
        Preconditions.checkNotNull((Object)path, (Object)"Endpoint path cannot be null");
        Preconditions.checkNotNull((Object)resourceId, (Object)"Endpoint identifier cannot be null");
        Preconditions.checkNotNull((Object)created, (Object)"Endpoint creation date cannot be null");
        Preconditions.checkNotNull((Object)entityTag, (Object)"Endpoint entity tag cannot be null");
        return new InMemoryEndpoint(path, resourceId, created, entityTag);
    }
}

