/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.kernel.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.ldp4j.application.kernel.impl.InMemoryResource;
import org.ldp4j.application.kernel.impl.InMemorySlug;
import org.ldp4j.application.kernel.resource.Container;
import org.ldp4j.application.kernel.resource.Member;
import org.ldp4j.application.kernel.resource.Resource;
import org.ldp4j.application.kernel.resource.ResourceId;
import org.ldp4j.application.kernel.resource.ResourceVisitor;
import org.ldp4j.application.kernel.resource.Slug;
import org.ldp4j.application.kernel.template.ContainerTemplate;

final class InMemoryContainer
extends InMemoryResource
implements Container {
    private final ConcurrentMap<ResourceId, Member> members = Maps.newConcurrentMap();
    private final AtomicLong memberCounter = new AtomicLong();
    private final ConcurrentMap<String, InMemorySlug> slugs = Maps.newConcurrentMap();

    InMemoryContainer(ResourceId id, ResourceId parentId) {
        super(id, parentId);
    }

    InMemoryContainer(ResourceId id) {
        this(id, null);
    }

    private Member createMember(InMemoryResource newResource) {
        InMemoryMember member = new InMemoryMember(this.id(), newResource.id(), this.memberCounter.incrementAndGet());
        Member result = this.members.putIfAbsent(member.memberId(), member);
        if (result == null) {
            result = member;
        }
        return result;
    }

    private InMemoryResource createMemberResource(ResourceId resourceId) {
        Preconditions.checkNotNull((Object)resourceId, (Object)"Member resource identifier cannot be null");
        Preconditions.checkState((!this.members.containsKey(resourceId) ? 1 : 0) != 0, (String)"A resource with id '%s' is already a member of the container", (Object[])new Object[]{resourceId});
        return this.createChild(resourceId, this.template().memberTemplate());
    }

    private ContainerTemplate template() {
        return (ContainerTemplate)super.getTemplate(this.id());
    }

    @Override
    public void accept(ResourceVisitor visitor) {
        visitor.visitContainer((Container)this);
    }

    public Resource addMember(ResourceId resourceId) {
        InMemoryResource newResource = this.createMemberResource(resourceId);
        this.createMember(newResource);
        return newResource;
    }

    public boolean hasMember(ResourceId resource) {
        return this.members.containsKey(resource);
    }

    public Set<Member> members() {
        return ImmutableSet.copyOf(this.members.values());
    }

    public Member findMember(ResourceId resourceId) {
        return (Member)this.members.get(resourceId);
    }

    public boolean removeMember(Member member) {
        Preconditions.checkNotNull((Object)member, (Object)"Member cannot be null");
        return this.members.remove(member.memberId(), member);
    }

    public Set<Slug> slugs() {
        return ImmutableSet.copyOf(this.slugs.values());
    }

    public Slug findSlug(String preferredPath) {
        return (Slug)this.slugs.get(preferredPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slug addSlug(String preferredPath) {
        Preconditions.checkNotNull((Object)preferredPath, (Object)"Preferred path cannot be null");
        InMemorySlug tmp = InMemorySlug.create(preferredPath, this);
        InMemorySlug slug = this.slugs.putIfAbsent(tmp.preferredPath(), tmp);
        if (slug == null) {
            return tmp;
        }
        InMemorySlug inMemorySlug = slug;
        synchronized (inMemorySlug) {
            if (slug.version() < tmp.version()) {
                slug.setVersion(tmp.version());
                return slug;
            }
            if (slug.version() == tmp.version()) {
                return slug;
            }
        }
        return this.addSlug(preferredPath + "_1");
    }

    @Override
    public String toString() {
        return this.stringHelper().add("memberCounter", (Object)this.memberCounter).add("members", this.members).add("slugs", this.slugs).toString();
    }

    private static final class InMemoryMember
    implements Member {
        private final ResourceId memberId;
        private final ResourceId containerId;
        private final long number;

        private InMemoryMember(ResourceId containerId, ResourceId memberId, long number) {
            this.memberId = memberId;
            this.containerId = containerId;
            this.number = number;
        }

        public long number() {
            return this.number;
        }

        public ResourceId containerId() {
            return this.containerId;
        }

        public ResourceId memberId() {
            return this.memberId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("number", this.number).add("containerId", (Object)this.containerId).add("memberId", (Object)this.memberId).toString();
        }
    }
}

