/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class PortugueseWikipediaRule
extends AbstractSimpleReplaceRule2 {
    public static final String WIKIPEDIA_COMMON_ERRORS = "PT_WIKIPEDIA_COMMON_ERRORS";
    private static final Locale PT_LOCALE = new Locale("pt");
    private final String path;

    public List<String> getFileNames() {
        return Collections.singletonList(this.path);
    }

    public PortugueseWikipediaRule(ResourceBundle messages, String path, Language language) {
        super(messages, language);
        this.path = Objects.requireNonNull(path);
        this.setCategory(Categories.WIKIPEDIA.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
        this.useSubRuleSpecificIds();
    }

    public String getId() {
        return WIKIPEDIA_COMMON_ERRORS;
    }

    public String getDescription() {
        return "Erros frequentes nos artigos da Wikip\u00e9dia: $match";
    }

    public String getShort() {
        return "Erro gramatical ou de normativa";
    }

    public String getMessage() {
        return "Poss\u00edvel erro em \"$match\". Prefira $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://pt.wikipedia.org/wiki/Wikip%C3%A9dia:Lista_de_erros_comuns/M%C3%A1quinas");
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

