/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.languagetool.JLanguageTool;

public class BrazilianToponymMapLoader {
    private final String toponymFilepath = "pt/brazilian_municipalities";
    private final List<String> states = Arrays.asList("AC", "AL", "AP", "AM", "BA", "CE", "DF", "ES", "GO", "MA", "MT", "MS", "MG", "PA", "PB", "PR", "PE", "PI", "RJ", "RN", "RS", "RO", "RR", "SC", "SP", "SE", "TO");

    BrazilianToponymMapLoader() {
    }

    private List<String> getToponymsFromState(String state) {
        List toponyms = JLanguageTool.getDataBroker().getFromResourceDirAsLines("pt/brazilian_municipalities/" + state + ".tsv");
        return toponyms.stream().map(toponym -> toponym.replace('-', ' ').toLowerCase()).collect(Collectors.toList());
    }

    public Map<String, List<String>> buildMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String state : this.states) {
            map.put(state, this.getToponymsFromState(state));
        }
        return map;
    }
}

