/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.languagetool.rules.pt.BrazilianToponymMapLoader;

public class BrazilianToponymMap {
    private final Map<String, List<String>> map = new BrazilianToponymMapLoader().buildMap();

    BrazilianToponymMap() {
    }

    private <T> T toponymIter(String toponym, Function<String, T> processor, T defaultValue) {
        String normalisedToponym = toponym.replace('-', ' ').toLowerCase();
        String[] toponymParts = normalisedToponym.split(" ");
        int toponymLength = toponymParts.length;
        for (int i = 0; i < toponymLength; ++i) {
            String toponymToCheck = String.join((CharSequence)" ", Arrays.copyOfRange(toponymParts, i, toponymLength));
            T result = processor.apply(toponymToCheck);
            if (result == null) continue;
            return result;
        }
        return defaultValue;
    }

    public boolean isValidToponym(String toponym) {
        return this.toponymIter(toponym, toponymToCheck -> this.map.values().stream().anyMatch(list -> list.contains(toponymToCheck)) ? Boolean.valueOf(true) : null, false);
    }

    public List<String> getStatesWithMunicipality(String toponym) {
        ArrayList<String> states = new ArrayList<String>();
        this.map.forEach((state, municipalities) -> {
            if (municipalities.contains(toponym)) {
                states.add((String)state);
            }
        });
        return states;
    }

    public boolean isToponymInState(String toponym, String state) {
        List<String> municipalities = this.map.get(state);
        return municipalities != null && municipalities.contains(toponym);
    }
}

