/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class BrazilianPortugueseReplaceRule
extends AbstractSimpleReplaceRule2 {
    public static final String BRAZILIAN_PORTUGUESE_SIMPLE_REPLACE_RULE = "PT_BR_SIMPLE_REPLACE";
    private static final Locale PT_LOCALE = new Locale("pt");
    private final String path;

    public List<String> getFileNames() {
        return Collections.singletonList(this.path);
    }

    public BrazilianPortugueseReplaceRule(ResourceBundle messages, String path, Language language) {
        super(messages, language);
        this.path = Objects.requireNonNull(path);
        this.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong((String)"<marker>hospedeira de bordo</marker>"), Example.fixed((String)"<marker>aeromo\u00e7a</marker>"));
        this.useSubRuleSpecificIds();
    }

    public String getId() {
        return BRAZILIAN_PORTUGUESE_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "Palavras portuguesas facilmente confundidas com as do Brasil";
    }

    public String getShort() {
        return "Palavra do portugu\u00eas de Portugal";
    }

    public String getMessage() {
        return "\"$match\" \u00e9 uma express\u00e3o usada sobretudo em Portugal. No portugu\u00eas brasileiro diz-se $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }

    protected boolean isTokenException(AnalyzedTokenReadings atr) {
        return atr.hasPosTagStartingWith("NP") || atr.isImmunized();
    }
}

