/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

public class QuestionWhitespaceRule
extends Rule {
    private static final Pattern urlPattern = Pattern.compile("^(file|s?ftp|finger|git|gopher|hdl|https?|shttp|imap|mailto|mms|nntp|s?news(post|reply)?|prospero|rsync|rtspu|sips?|svn|svn\\+ssh|telnet|wais)$");
    private static final String ESPACE_FINE_INSECABLE = "\u202f";
    private static final String NBSP = "\u00a0";
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(new PatternTokenBuilder().tokenRegex("[:;]").build(), new PatternTokenBuilder().csToken("-").setIsWhiteSpaceBefore(false).build(), new PatternTokenBuilder().tokenRegex("[\\(\\)D]").setIsWhiteSpaceBefore(false).build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("[:;]").build(), new PatternTokenBuilder().tokenRegex("[\\(\\)D]").setIsWhiteSpaceBefore(false).build()), Arrays.asList(new PatternTokenBuilder().tokenRegex(".*\\d{1,2}").build(), new PatternTokenBuilder().token(":").build(), new PatternTokenBuilder().tokenRegex("\\d{1,2}").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("[?!]").build(), new PatternTokenBuilder().tokenRegex("[?!]").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("[a-z0-9]{2}").build(), new PatternTokenBuilder().token(":").build(), new PatternTokenBuilder().tokenRegex("[a-z0-9]{2}").build(), new PatternTokenBuilder().token(":").build(), new PatternTokenBuilder().tokenRegex("[a-z0-9]{2}").build()), Arrays.asList(new PatternTokenBuilder().token(";").build(), new PatternTokenBuilder().tokenRegex(".+").setIsWhiteSpaceBefore(false).build(), new PatternTokenBuilder().token(";").setIsWhiteSpaceBefore(false).build()), Arrays.asList(new PatternTokenBuilder().tokenRegex(".+").setIsWhiteSpaceBefore(false).build(), new PatternTokenBuilder().token(";").setIsWhiteSpaceBefore(false).build(), new PatternTokenBuilder().tokenRegex(".+").setIsWhiteSpaceBefore(false).build()));
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    public QuestionWhitespaceRule(ResourceBundle messages, Language language) {
        super.setCategory(Categories.MISC.getCategory(messages));
        this.antiPatterns = QuestionWhitespaceRule.cacheAntiPatterns((Language)language, ANTI_PATTERNS);
    }

    public String getId() {
        return "FRENCH_WHITESPACE";
    }

    public String getDescription() {
        return "Insertion des espaces fines ins\u00e9cables";
    }

    protected boolean isAllowedWhitespaceChar(AnalyzedTokenReadings[] tokens, int i) {
        return i >= 0 ? tokens[i].isWhitespace() : false;
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokens();
        String prevPrevToken = "";
        String prevToken = "";
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            if (tokens[i].isImmunized() || prevToken.equals("(") || prevToken.equals("[")) {
                prevPrevToken = prevToken;
                prevToken = token;
                continue;
            }
            String msg = null;
            String suggestionText = null;
            int iFrom = i - 1;
            int iTo = i;
            boolean isPreviousWhitespace = i > 0 ? tokens[i - 1].isWhitespace() : false;
            String prevTokenToChange = prevToken;
            if (isPreviousWhitespace) {
                prevTokenToChange = "";
            }
            if (!this.isAllowedWhitespaceChar(tokens, i - 1)) {
                if (token.equals("?") && !prevToken.equals("!")) {
                    msg = "Le point d'interrogation est pr\u00e9c\u00e9d\u00e9 d'une espace fine ins\u00e9cable.";
                    suggestionText = prevTokenToChange + ESPACE_FINE_INSECABLE + "?";
                } else if (token.equals("!") && !prevToken.equals("?")) {
                    msg = "Le point d'exclamation est pr\u00e9c\u00e9d\u00e9 d'une espace fine ins\u00e9cable.";
                    suggestionText = prevTokenToChange + ESPACE_FINE_INSECABLE + "!";
                } else if (token.equals(";")) {
                    msg = "Le point-virgule est pr\u00e9c\u00e9d\u00e9 d'une espace fine ins\u00e9cable.";
                    suggestionText = prevTokenToChange + ESPACE_FINE_INSECABLE + ";";
                } else if (token.equals(":")) {
                    Matcher matcherUrl = urlPattern.matcher(prevToken);
                    if (!matcherUrl.find()) {
                        msg = "Les deux-points sont pr\u00e9c\u00e9d\u00e9s d'une espace ins\u00e9cable.";
                        suggestionText = prevTokenToChange + NBSP + ":";
                    }
                } else if (token.equals("\u00bb")) {
                    if (prevPrevToken.equals("\u00ab")) {
                        msg = "Les guillemets sont toujours accompagn\u00e9s d'une espace ins\u00e9cable.";
                        suggestionText = "\u00ab\u00a0" + prevTokenToChange + NBSP + "\u00bb";
                        iFrom = i - 2;
                    } else {
                        msg = "Le guillemet fermant est pr\u00e9c\u00e9d\u00e9 d'une espace ins\u00e9cable.";
                        suggestionText = prevTokenToChange + NBSP + "\u00bb";
                    }
                }
            }
            if (prevToken.equals("\u00ab")) {
                if (StringTools.isEmpty((String)token)) {
                    msg = "Le guillemet ouvrant est suivi d'une espace ins\u00e9cable.";
                    suggestionText = "\u00ab\u00a0";
                    iTo = i - 1;
                } else if (!this.isAllowedWhitespaceChar(tokens, i)) {
                    String nextToken = "";
                    if (i + 1 < tokens.length) {
                        nextToken = tokens[i + 1].getToken();
                    }
                    if (!nextToken.equals("\u00bb")) {
                        msg = "Le guillemet ouvrant est suivi d'une espace ins\u00e9cable.";
                        suggestionText = !tokens[i].isWhitespace() ? "\u00ab\u00a0" + token : "\u00ab\u00a0";
                    }
                }
            }
            if (msg != null) {
                int fromPos = tokens[iFrom].getStartPos();
                int toPos = tokens[iTo].getEndPos();
                RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, fromPos, toPos, msg, "Ins\u00e9rer une espace ins\u00e9cable");
                ruleMatch.setSuggestedReplacement(suggestionText);
                ruleMatches.add(ruleMatch);
            }
            prevPrevToken = prevToken;
            prevToken = token;
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

