/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractCompoundRule;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.Example;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.Tools;

public class CompoundRule
extends AbstractCompoundRule {
    private static SpellingCheckRule englishSpellerRule;
    private static volatile CompoundRuleData compoundData;
    private static final Language AMERICAN_ENGLISH;
    private static final List<DisambiguationPatternRule> ANTI_PATTERNS;

    public CompoundRule(ResourceBundle messages, Language lang, UserConfig userConfig) throws IOException {
        super(messages, lang, userConfig, "This word is normally spelled with a hyphen.", "This word is normally spelled as one.", "This expression is normally spelled as one or with a hyphen.", "Compound");
        this.addExamplePair(Example.wrong((String)"I now have a <marker>part time</marker> job."), Example.fixed((String)"I now have a <marker>part-time</marker> job."));
        this.setUrl(Tools.getUrl((String)"https://languagetool.org/insights/post/hyphen/"));
        if (englishSpellerRule == null) {
            englishSpellerRule = lang.getDefaultSpellingRule(messages);
        }
    }

    public String getId() {
        return "EN_COMPOUNDS";
    }

    public String getDescription() {
        return "Hyphenated words, e.g., 'case-sensitive' instead of 'case sensitive'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompoundRuleData getCompoundRuleData() {
        CompoundRuleData data = compoundData;
        if (data != null) return data;
        Class<CompoundRule> clazz = CompoundRule.class;
        synchronized (CompoundRule.class) {
            data = compoundData;
            if (data != null) return data;
            compoundData = data = new CompoundRuleData("/en/compounds.txt");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return data;
        }
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return ANTI_PATTERNS;
    }

    public boolean isMisspelled(String word) throws IOException {
        return englishSpellerRule.isMisspelled(word);
    }

    static {
        AMERICAN_ENGLISH = Languages.getLanguageForShortCode((String)"en-US");
        ANTI_PATTERNS = CompoundRule.makeAntiPatterns(Arrays.asList(Arrays.asList(new PatternTokenBuilder().tokenRegex("['\u2019`\u00b4\u2018]").build(), new PatternTokenBuilder().token("re").build()), Arrays.asList(new PatternTokenBuilder().posRegex("SENT_START|CC|PCT").build(), new PatternTokenBuilder().tokenRegex("we|you|they|I|s?he|it").build(), new PatternTokenBuilder().token("well").build(), new PatternTokenBuilder().posRegex("VB.*").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("and|&").build(), new PatternTokenBuilder().token("co").build()), Arrays.asList(new PatternTokenBuilder().token("power").build(), new PatternTokenBuilder().token("off").build(), new PatternTokenBuilder().token("key").build()), Arrays.asList(new PatternTokenBuilder().token("see").build(), new PatternTokenBuilder().token("saw").build(), new PatternTokenBuilder().token("seen").build()), Arrays.asList(new PatternTokenBuilder().token("forward").build(), new PatternTokenBuilder().token("looking").build(), new PatternTokenBuilder().posRegex("IN|TO").build()), Arrays.asList(new PatternTokenBuilder().token("store").build(), new PatternTokenBuilder().token("front").build(), new PatternTokenBuilder().tokenRegex("doors?").build()), Arrays.asList(new PatternTokenBuilder().token("from").build(), new PatternTokenBuilder().token("surface").build(), new PatternTokenBuilder().token("to").build(), new PatternTokenBuilder().token("surface").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("senior|junior").build(), new PatternTokenBuilder().token("year").build(), new PatternTokenBuilder().token("end").build()), Arrays.asList(new PatternTokenBuilder().token("under").build(), new PatternTokenBuilder().token("investment").build(), new PatternTokenBuilder().token("banking").build()), Arrays.asList(new PatternTokenBuilder().token("spring").build(), new PatternTokenBuilder().tokenRegex("cleans?|cleaned|cleaning").build(), new PatternTokenBuilder().tokenRegex("up|the|my|our|his|her").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("series?").build(), new PatternTokenBuilder().tokenRegex("a").build()), Arrays.asList(new PatternTokenBuilder().token("hard").build(), new PatternTokenBuilder().token("time").build(), new PatternTokenBuilder().pos("VBG").build()), Arrays.asList(new PatternTokenBuilder().token("first").build(), new PatternTokenBuilder().tokenRegex("ever").build(), new PatternTokenBuilder().tokenRegex("green").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex(".+").build(), new PatternTokenBuilder().token(".").build(), new PatternTokenBuilder().tokenRegex("(com|io|de|nl|co|net|org|es)").build())), (Language)AMERICAN_ENGLISH);
    }
}

