/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.languagetool.synthesis.GermanSynthesizer;
import org.languagetool.tools.StringTools;

public class LineExpander
implements org.languagetool.rules.LineExpander {
    private static final LoadingCache<String, String[]> verbFormCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String[]>(){

        public String[] load(@NotNull String verb) throws IOException {
            return GermanSynthesizer.INSTANCE.synthesizeForPosTags(verb, s -> s.startsWith("VER:"));
        }
    });

    private static List<String> handleLineWithPrefix(String line) {
        ArrayList<String> result = new ArrayList<String>();
        String[] parts = LineExpander.cleanTagsAndEscapeChars(line).split("_");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Unexpected line format, expected at most one '_': " + line);
        }
        if (parts[0].contains("/") || parts[1].contains("/")) {
            throw new IllegalArgumentException("Unexpected line format, '_' cannot be combined with '/': " + line);
        }
        if (parts[1].equals("in")) {
            result.add(parts[0] + "_in");
            result.add(parts[0] + "_innen");
            result.add(parts[0] + "*in");
            result.add(parts[0] + "*innen");
            result.add(parts[0] + ":in");
            result.add(parts[0] + ":innen");
        } else {
            String[] forms = (String[])verbFormCache.getUnchecked((Object)parts[1]);
            if (forms.length == 0) {
                throw new RuntimeException("Could not expand '" + parts[1] + "' from line '" + line + "', no forms found");
            }
            HashSet<String> formSet = new HashSet<String>(Arrays.asList(forms));
            for (String form : formSet) {
                if (form.contains("\u00df") || form.length() <= 0 || !Character.isLowerCase(form.charAt(0))) continue;
                result.add(parts[0] + form);
            }
            result.add(parts[0] + "zu" + parts[1]);
            result.add(StringTools.uppercaseFirstChar((String)parts[0]) + parts[1] + "s");
        }
        return result;
    }

    public List<String> expandLine(String line) {
        return this.isLineWithVerbPrefix(line) ? LineExpander.handleLineWithPrefix(line) : (this.isLineWithFlag(line) ? this.handleLineWithFlags(line) : Collections.singletonList(LineExpander.cleanTagsAndEscapeChars(line)));
    }

    private boolean isLineWithFlag(String line) {
        int idx = line.indexOf(47);
        return !line.startsWith("#") && idx > 0 && line.charAt(idx - 1) != '\\';
    }

    private boolean isLineWithVerbPrefix(String line) {
        int idx = line.indexOf(95);
        return !line.startsWith("#") && idx > 0 && line.charAt(idx - 1) != '\\';
    }

    private List<String> handleLineWithFlags(String line) {
        ArrayList<String> result = new ArrayList<String>();
        String[] parts = LineExpander.cleanTagsAndEscapeChars(line).split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Unexpected line format, expected at most one slash: " + line);
        }
        String word = parts[0];
        String suffix = parts[1];
        for (int i = 0; i < suffix.length(); ++i) {
            char c = suffix.charAt(i);
            if (c == 'S') {
                this.add(result, word);
                result.add(word + "s");
                continue;
            }
            if (c == 'N') {
                this.add(result, word);
                result.add(word + "n");
                continue;
            }
            if (c == 'E') {
                this.add(result, word);
                result.add(word + "e");
                continue;
            }
            if (c == 'F') {
                this.add(result, word);
                result.add(word + "in");
                continue;
            }
            if (c == 'T') {
                this.add(result, word);
                if (word.endsWith("stra\u00dfe") || word.endsWith("strasse")) {
                    result.add(word.replaceAll("stra(\u00df|ss)e", "str."));
                }
                if (!word.endsWith("Stra\u00dfe") && !word.endsWith("Strasse")) continue;
                result.add(word.replaceAll("Stra(\u00df|ss)e", "Str."));
                continue;
            }
            if (c == 'A' || c == 'P') {
                this.add(result, word);
                if (word.endsWith("e")) {
                    result.add(word + "r");
                    result.add(word + "s");
                    result.add(word + "n");
                    result.add(word + "m");
                    continue;
                }
                result.add(word + "e");
                result.add(word + "er");
                result.add(word + "es");
                result.add(word + "en");
                result.add(word + "em");
                continue;
            }
            throw new IllegalArgumentException("Unknown suffix: " + suffix + " in line: " + line);
        }
        return result;
    }

    private void add(List<String> result, String word) {
        if (!result.contains(word)) {
            result.add(word);
        }
    }

    private static String cleanTagsAndEscapeChars(String s) {
        int idx = s.indexOf(35);
        if (idx != -1) {
            s = s.substring(0, idx);
        }
        return s.replaceAll("\\\\", "").trim();
    }
}

