/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class CompoundCoherencyRule
extends TextLevelRule {
    public CompoundCoherencyRule(ResourceBundle messages) {
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Ein Helpdesk gliedert sich in verschiedene Level. Die Qualit\u00e4t des <marker>Help-Desks</marker> ist wichtig."), Example.fixed((String)"Ein Helpdesk gliedert sich in verschiedene Level. Die Qualit\u00e4t des <marker>Helpdesks</marker> ist wichtig."));
    }

    public String getId() {
        return "DE_COMPOUND_COHERENCY";
    }

    public String getDescription() {
        return "Einheitliche Schreibweise bei Komposita (mit oder ohne Bindestrich)";
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        HashMap normToTextOccurrences = new HashMap();
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens;
            for (AnalyzedTokenReadings atr : tokens = sentence.getTokensWithoutWhitespace()) {
                String lemmaOrNull = this.getLemma(atr);
                String token = atr.getToken();
                if (token.isEmpty()) continue;
                String lemma = lemmaOrNull != null ? lemmaOrNull : token;
                String normToken = lemma.replace("-", "").toLowerCase();
                if (StringUtils.isNumeric((CharSequence)normToken)) break;
                List textOcc = (List)normToTextOccurrences.get(normToken);
                if (textOcc != null) {
                    String other;
                    if (!textOcc.stream().noneMatch(f -> f.equalsIgnoreCase(lemma)) || !this.containsHyphenInside(other = (String)textOcc.get(0)) && !this.containsHyphenInside(token)) continue;
                    String msg = "Uneinheitliche Verwendung von Bindestrichen. Der Text enth\u00e4lt sowohl '" + token + "' als auch '" + other + "'.";
                    RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, pos + atr.getStartPos(), pos + atr.getEndPos(), msg);
                    if (token.replace("-", "").equalsIgnoreCase(other.replace("-", ""))) {
                        ruleMatch.setSuggestedReplacement(other);
                    }
                    ruleMatches.add(ruleMatch);
                    continue;
                }
                ArrayList<String> l = new ArrayList<String>();
                l.add(lemma);
                normToTextOccurrences.putIfAbsent(normToken, l);
            }
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean containsHyphenInside(String token) {
        return token.contains("-") && !token.startsWith("-") && !token.endsWith("-");
    }

    @Nullable
    private String getLemma(AnalyzedTokenReadings atr) {
        String lemmaOrNull;
        String string = lemmaOrNull = atr.hasSameLemmas() && atr.getReadingsLength() > 0 ? ((AnalyzedToken)atr.getReadings().get(0)).getLemma() : null;
        if (lemmaOrNull != null) {
            String token = atr.getToken();
            if (!lemmaOrNull.contains("-") && token.contains("-")) {
                StringBuilder lemmaBuilder = new StringBuilder();
                int lemmaPos = 0;
                for (int tokenPos = 0; lemmaPos < lemmaOrNull.length() && tokenPos < token.length(); ++lemmaPos, ++tokenPos) {
                    char tokenChar;
                    char lemmaChar = lemmaOrNull.charAt(lemmaPos);
                    if (lemmaChar == (tokenChar = token.charAt(tokenPos))) {
                        lemmaBuilder.append(lemmaChar);
                        continue;
                    }
                    if (token.charAt(tokenPos) != '-') continue;
                    lemmaBuilder.append('-');
                    if (lemmaPos + 1 < token.length() && Character.isUpperCase(token.charAt(++tokenPos))) {
                        lemmaBuilder.append(Character.toUpperCase(lemmaChar));
                        continue;
                    }
                    lemmaBuilder.append(lemmaChar);
                }
                return lemmaBuilder.toString();
            }
            return lemmaOrNull;
        }
        return null;
    }

    public int minToCheckParagraph() {
        return -1;
    }
}

