/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStatisticStyleRule;
import org.languagetool.rules.Rule;

public class GermanFillerWordsRule
extends AbstractStatisticStyleRule {
    private static final int DEFAULT_MIN_PERCENT = 8;
    private static final String DEFAULT_SENTENCE_MSG1 = "Zwei potentielle F\u00fcllw\u00f6rter hintereinander. Mindestens eins sollte gel\u00f6scht werden.";
    private static final String DEFAULT_SENTENCE_MSG2 = "Mehr als zwei potentielle F\u00fcllw\u00f6rter in einem Satz. Mindestens eins sollte gel\u00f6scht werden.";
    private static final Set<String> fillerWords = new HashSet<String>(Arrays.asList("aber", "abermals", "allein", "allemal", "allenfalls", "allenthalben", "allerdings", "allesamt", "allzu", "also", "alt", "andauernd", "andererseits", "andernfalls", "anscheinend", "auch", "auffallend", "augenscheinlich", "ausdr\u00fccklich", "ausgerechnet", "ausnahmslos", "au\u00dferdem", "\u00e4u\u00dferst", "beinahe", "bekanntlich", "bereits", "besonders", "bestenfalls", "bestimmt", "blo\u00df", "dabei", "dadurch", "daf\u00fcr", "dagegen", "daher", "damals", "danach", "demgegen\u00fcber", "demgem\u00e4\u00df", "demnach", "denkbar", "denn", "dennoch", "deshalb", "deswegen", "doch", "durchaus", "durchweg", "eben", "eigentlich", "einerseits", "einfach", "einige", "einigerma\u00dfen", "einmal", "ergo", "erheblich", "etliche", "etwa", "etwas", "fast", "folgenderma\u00dfen", "folglich", "f\u00f6rmlich", "fortw\u00e4hrend", "fraglos", "freilich", "ganz", "g\u00e4nzlich", "gar", "gelegentlich", "gemeinhin", "genau", "geradezu", "gewiss", "gewisserma\u00dfen", "glatt", "gleichsam", "gleichwohl", "gl\u00fccklicherweise", "gottseidank", "gr\u00f6\u00dftenteils", "h\u00e4ufig", "hingegen", "hinl\u00e4nglich", "h\u00f6chst", "h\u00f6chstens", "immer", "immerhin", "immerzu", "indessen", "infolgedessen", "insbesondere", "inzwischen", "irgend", "irgendein", "irgendjemand", "irgendwann", "irgendwie", "irgendwo", "ja", "je", "jedenfalls", "jedoch", "jemals", "kaum", "keinesfalls", "keineswegs", "l\u00e4ngst", "lediglich", "leider", "letztlich", "manchmal", "mehrfach", "meinetwegen", "meist", "meistens", "meistenteils", "mindestens", "mithin", "mitunter", "m\u00f6glicherweise", "m\u00f6glichst", "n\u00e4mlich", "naturgem\u00e4\u00df", "nat\u00fcrlich", "neuerdings", "neuerlich", "neulich", "nichtsdestoweniger", "nie", "niemals", "nun", "nur", "offenbar", "offenkundig", "offensichtlich", "oft", "ohnedies", "partout", "pl\u00f6tzlich", "praktisch", "quasi", "recht", "reichlich", "reiflich", "relativ", "restlos", "richtiggehend", "rundheraus", "rundum", "sattsam", "schlicht", "schlichtweg", "schlie\u00dflich", "schlussendlich", "schon", "sehr", "selbst", "selbstredend", "selbstverst\u00e4ndlich", "selten", "seltsamerweise", "sicher", "sicherlich", "so", "sogar", "sonst", "sowieso", "sozusagen", "stellenweise", "stets", "trotzdem", "\u00fcberaus", "\u00fcberdies", "\u00fcberhaupt", "\u00fcbrigens", "umst\u00e4ndehalber", "unbedingt", "unerh\u00f6rt", "ungef\u00e4hr", "ungemein", "ungew\u00f6hnlich", "ungleich", "ungl\u00fccklicherweise", "unl\u00e4ngst", "unma\u00dfgeblich", "unsagbar", "uns\u00e4glich", "unstreitig", "unzweifelhaft", "vergleichsweise", "vermutlich", "vielfach", "vielleicht", "voll", "vollends", "v\u00f6llig", "vollkommen", "vollst\u00e4ndig", "wahrscheinlich", "weidlich", "weitgehend", "wenigstens", "wieder", "wiederum", "wirklich", "wohl", "wohlgemerkt", "wom\u00f6glich", "ziemlich", "zudem", "zugegeben", "zumeist", "zusehends", "zuweilen", "zweifellos", "zweifelsfrei", "zweifelsohne"));
    String sentenceMessage = null;

    public GermanFillerWordsRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig, 8);
        LinguServices linguServices;
        if (userConfig != null && (linguServices = userConfig.getLinguServices()) != null) {
            linguServices.setThesaurusRelevantRule((Rule)this);
        }
    }

    private static boolean isException(AnalyzedTokenReadings[] tokens, int num) {
        int i;
        if (num == 1 || ",".equals(tokens[num - 1].getToken())) {
            return true;
        }
        if ("allein".equals(tokens[num].getToken())) {
            for (int i2 = 1; i2 < tokens.length; ++i2) {
                if (!tokens[i2].hasLemma("sein")) continue;
                return true;
            }
            return false;
        }
        if ("recht".equals(tokens[num].getToken())) {
            for (i = 1; i < tokens.length; ++i) {
                if (!tokens[i].hasAnyLemma(new String[]{"haben", "geben"})) continue;
                return true;
            }
        }
        if (("so".equals(tokens[num].getToken()) || "besonders".equals(tokens[num].getToken())) && tokens[num + 1].hasPosTagStartingWith("ADJ")) {
            return true;
        }
        if (tokens[num].hasPosTagStartingWith("ADJ") && "so".equals(tokens[num - 1].getToken())) {
            return true;
        }
        if ("nur".equals(tokens[num].getToken()) && "nicht".equals(tokens[num - 1].getToken())) {
            for (i = num + 1; i < tokens.length - 2; ++i) {
                if (!",".equals(tokens[i].getToken()) || !"auch".equals(tokens[i + 1].getToken()) && (!"sondern".equals(tokens[i + 1].getToken()) || !"auch".equals(tokens[i + 2].getToken()))) continue;
                return true;
            }
        }
        if (num > 2 && "auch".equals(tokens[num].getToken()) && "sondern".equals(tokens[num - 1].getToken()) && ",".equals(tokens[num - 2].getToken())) {
            for (i = 1; i < num - 2; ++i) {
                if (!"nicht".equals(tokens[i].getToken()) || !"nur".equals(tokens[i + 1].getToken())) continue;
                return true;
            }
        }
        return false;
    }

    protected int conditionFulfilled(AnalyzedTokenReadings[] tokens, int nToken) {
        if (!(!fillerWords.contains(tokens[nToken].getToken()) || GermanFillerWordsRule.isException(tokens, nToken) || nToken >= 2 && GermanFillerWordsRule.isTwoWordException(tokens[nToken - 1].getToken(), tokens[nToken].getToken()) || nToken <= tokens.length - 2 && GermanFillerWordsRule.isTwoWordException(tokens[nToken].getToken(), tokens[nToken + 1].getToken()))) {
            return nToken;
        }
        return -1;
    }

    private static boolean isTwoWordException(String first, String second) {
        return "aber".equals(first) && ("nur".equals(second) || "auch".equals(second)) || "auch".equals(first) && "nur".equals(second) || "immer".equals(first) && "wieder".equals(second) || "genau".equals(first) && "so".equals(second) || "so".equals(first) && ("etwas".equals(second) || "viel".equals(second) || "oft".equals(second)) || "schon".equals(first) && "fast".equals(second);
    }

    protected boolean sentenceConditionFulfilled(AnalyzedTokenReadings[] tokens, int nToken) {
        int i;
        if (nToken > 1 && fillerWords.contains(tokens[nToken - 1].getToken()) && !GermanFillerWordsRule.isException(tokens, nToken - 1) || nToken < tokens.length - 1 && fillerWords.contains(tokens[nToken + 1].getToken()) && !GermanFillerWordsRule.isException(tokens, nToken + 1)) {
            this.sentenceMessage = DEFAULT_SENTENCE_MSG1;
            return true;
        }
        int n = 0;
        for (i = nToken - 2; i > 0; --i) {
            if (this.conditionFulfilled(tokens, i) != i || ++n <= 1) continue;
            this.sentenceMessage = DEFAULT_SENTENCE_MSG2;
            return true;
        }
        for (i = nToken + 2; i < tokens.length; ++i) {
            if (this.conditionFulfilled(tokens, i) != i || ++n <= 1) continue;
            this.sentenceMessage = DEFAULT_SENTENCE_MSG2;
            return true;
        }
        return false;
    }

    protected boolean excludeDirectSpeech() {
        return true;
    }

    protected String getLimitMessage(int limit, double percent) {
        if (limit == 0) {
            return "Dieses Wort k\u00f6nnte ein F\u00fcllwort sein. M\u00f6glicherweise ist es besser es zu l\u00f6schen.";
        }
        return "Mehr als " + limit + "% F\u00fcllw\u00f6rter {" + (int)(percent + 0.5) + "%} gefunden. M\u00f6glicherweise ist es besser dieses potentielle F\u00fcllwort zu l\u00f6schen.";
    }

    protected String getSentenceMessage() {
        return this.sentenceMessage;
    }

    public String getId() {
        return "FILLER_WORDS_DE";
    }

    public String getDescription() {
        return "Statistische Stilanalyse: F\u00fcllw\u00f6rter";
    }

    public String getConfigureText() {
        return "Anzeigen wenn mehr als ...% eines Kapitels F\u00fcllw\u00f6rter sind:";
    }
}

