/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.server;

import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.ladsn.security.core.properties.OAuth2ClientProperties;
import org.ladsn.security.core.properties.SecurityProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.config.annotation.builders.InMemoryClientDetailsServiceBuilder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;

@Configuration
@EnableAuthorizationServer
public class LadsnAuthorizationServerConfig
extends AuthorizationServerConfigurerAdapter {
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private TokenStore tokenStore;
    @Autowired(required=false)
    private JwtAccessTokenConverter jwtAccessTokenConverter;
    @Autowired(required=false)
    private TokenEnhancer jwtTokenEnhancer;
    @Autowired
    private SecurityProperties securityProperties;

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
        endpoints.tokenStore(this.tokenStore).authenticationManager(this.authenticationManager).userDetailsService(this.userDetailsService);
        if (this.jwtAccessTokenConverter != null && this.jwtTokenEnhancer != null) {
            TokenEnhancerChain enhancerChain = new TokenEnhancerChain();
            ArrayList<Object> enhancers = new ArrayList<Object>();
            enhancers.add(this.jwtTokenEnhancer);
            enhancers.add(this.jwtAccessTokenConverter);
            enhancerChain.setTokenEnhancers(enhancers);
            endpoints.tokenEnhancer((TokenEnhancer)enhancerChain).accessTokenConverter((AccessTokenConverter)this.jwtAccessTokenConverter);
        }
    }

    public void configure(AuthorizationServerSecurityConfigurer security) throws Exception {
        security.tokenKeyAccess("permitAll()");
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        InMemoryClientDetailsServiceBuilder builder = clients.inMemory();
        if (ArrayUtils.isNotEmpty((Object[])this.securityProperties.getOauth2().getClients())) {
            for (OAuth2ClientProperties client : this.securityProperties.getOauth2().getClients()) {
                builder.withClient(client.getClientId()).secret(client.getClientSecret()).authorizedGrantTypes(new String[]{"refresh_token", "authorization_code", "password"}).accessTokenValiditySeconds(client.getAccessTokenValidateSeconds()).refreshTokenValiditySeconds(2592000).scopes(new String[]{"all"});
            }
        }
    }
}

