/*
 * Decompiled with CFR 0.152.
 */
package org.l6n.sendlog;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Spinner;
import java.util.ArrayList;
import java.util.List;
import org.l6n.sendlog.SendLog;

public class CreateShortcutActivity
extends Activity
implements TextWatcher,
View.OnClickListener {
    private EditText mNameView;
    private EditText mDestView;
    private Spinner mFormatSpinner;
    private Spinner mSenderSpinner;
    private SenderAdapter mSenderAdapter;

    public void onCreate(Bundle pSavedInstanceState) {
        super.onCreate(pSavedInstanceState);
        this.setContentView(2130903041);
        this.mNameView = (EditText)this.findViewById(2131099649);
        this.mNameView.setError(this.getText(2130968589));
        this.mNameView.addTextChangedListener((TextWatcher)this);
        this.findViewById(2131099653).setOnClickListener((View.OnClickListener)this);
        this.findViewById(2131099654).setOnClickListener((View.OnClickListener)this);
        this.mDestView = (EditText)this.findViewById(2131099650);
        this.mDestView.setError(this.getText(2130968589));
        this.mDestView.addTextChangedListener((TextWatcher)this);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this);
        int format = sp.getInt("FORMAT", 5);
        this.mFormatSpinner = (Spinner)this.findViewById(2131099651);
        this.mFormatSpinner.setSelection(format);
        this.mSenderAdapter = new SenderAdapter();
        this.mSenderSpinner = (Spinner)this.findViewById(2131099652);
        this.mSenderSpinner.setAdapter(this.mSenderAdapter.getInstance((Context)this));
    }

    public void afterTextChanged(Editable pS) {
        if (this.mNameView.length() == 0) {
            this.mNameView.setError(this.getText(2130968589));
        } else {
            this.mNameView.setError(null);
        }
        if (this.mDestView.length() == 0) {
            this.mDestView.setError(this.getText(2130968589));
        } else {
            this.mDestView.setError(null);
        }
    }

    public void beforeTextChanged(CharSequence pS, int pStart, int pCount, int pAfter) {
    }

    public void onTextChanged(CharSequence pS, int pStart, int pBefore, int pCount) {
    }

    public void onClick(View pView) {
        switch (pView.getId()) {
            case 2131099653: {
                Intent intent = this.createShortcutIntent();
                if (intent == null) break;
                this.setResult(-1, intent);
                this.finish();
                break;
            }
            case 2131099654: {
                this.setResult(0);
                this.finish();
            }
        }
    }

    private Intent createShortcutIntent() {
        if (this.mNameView.length() > 0 && this.mDestView.length() > 0) {
            Intent intent = new Intent((Context)this, SendLog.class);
            Editable dest = this.mDestView.getText();
            int format = this.mFormatSpinner.getSelectedItemPosition();
            int senderPos = this.mSenderSpinner.getSelectedItemPosition();
            ResolveInfo ri = this.mSenderAdapter.ri.get(senderPos);
            intent.setType(format + "|" + ri.activityInfo.name + "|" + dest.toString());
            Intent shortcut = new Intent();
            shortcut.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)intent);
            shortcut.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)Intent.ShortcutIconResource.fromContext((Context)this, (int)2130837504));
            shortcut.putExtra("android.intent.extra.shortcut.NAME", this.mNameView.getText().toString());
            return shortcut;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SenderAdapter {
        final PackageManager pm;
        final Intent sendIntent;
        final List<ResolveInfo> ri;
        final ArrayList<String> names;
        final ArrayList<Drawable> icons;

        public SenderAdapter() {
            this.pm = CreateShortcutActivity.this.getPackageManager();
            this.sendIntent = new Intent("android.intent.action.SEND").setType("message/rfc822");
            this.ri = this.pm.queryIntentActivities(this.sendIntent, 65536);
            this.names = new ArrayList();
            this.icons = new ArrayList();
            for (ResolveInfo info : this.ri) {
                ApplicationInfo ai = info.activityInfo.applicationInfo;
                this.names.add(this.pm.getApplicationLabel(ai).toString());
                this.icons.add(this.pm.getApplicationIcon(ai));
            }
        }

        public ArrayAdapter<String> getInstance(Context pContext) {
            return new ArrayAdapter<String>(pContext, 17367048, this.names){

                public View getDropDownView(int pPosition, View pConvertView, ViewGroup pParent) {
                    View view = pConvertView == null ? View.inflate((Context)CreateShortcutActivity.this.getApplicationContext(), (int)2130903040, null) : pConvertView;
                    ImageView iconView = (ImageView)view.findViewById(2131099648);
                    iconView.setImageDrawable(SenderAdapter.this.icons.get(pPosition));
                    CheckedTextView tv = (CheckedTextView)view.findViewById(16908308);
                    tv.setText((CharSequence)SenderAdapter.this.names.get(pPosition));
                    tv.setChecked(pPosition == CreateShortcutActivity.this.mSenderSpinner.getSelectedItemPosition());
                    return view;
                }
            };
        }
    }
}

