/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.rpkgtests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.apache.maven.shared.transfer.repository.RepositoryManager;
import org.l2x6.rpkgtests.AbstractTestJarsConsumerMojo;
import org.l2x6.rpkgtests.Gav;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mojo(name="rpkgtests", requiresDependencyResolution=ResolutionScope.NONE, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class RepackageAndInstallTestJarsMojo
extends AbstractTestJarsConsumerMojo {
    @Parameter(property="rpkgtests.workDir", defaultValue="${project.build.directory}/rpkgtests")
    private File workDir;
    @Parameter(property="rpkgtests.force", defaultValue="false")
    private boolean force;
    @Parameter(property="rpkgtests.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pomRemoteRepositories;
    @Component
    private MavenProject project;
    @Component
    private MavenSession session;
    @Component
    private DependencyResolver dependencyResolver;
    @Component
    private RepositoryManager repositoryManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping as requested via the skip mojo parameter");
        }
        for (Gav artifact : this.getTestJarsOrFail()) {
            LocalRepoArtifact localRepoArtifact = this.createLocalRepoArtifact(artifact);
            boolean installed = localRepoArtifact.installed;
            boolean isSnapshot = artifact.version.endsWith("-SNAPSHOT");
            boolean performRpkg = this.force || !installed || isSnapshot;
            this.getLog().info((CharSequence)("force = " + this.force + "; " + localRepoArtifact.artifact + (installed ? " installed;" : " not installed;") + (isSnapshot ? " is SNAPSHOT;" : " is not SNAPSHOT;") + (performRpkg ? " thus repackaging" : " thus skipping the repackaging")));
            if (!performRpkg) continue;
            this.download(localRepoArtifact);
            InstallableArtifact installable = this.transform(localRepoArtifact);
            this.install(installable);
        }
    }

    private LocalRepoArtifact createLocalRepoArtifact(Gav artifact) {
        ProjectBuildingRequest request = this.session.getProjectBuildingRequest();
        Path repoRoot = this.repositoryManager.getLocalRepositoryBasedir(request).toPath();
        String newAId = artifact.artifactId + "-rpkgtests";
        Path newJarPath = repoRoot.resolve(this.repositoryManager.getPathForLocalArtifact(request, artifact.asArtifactCoordinate(newAId, "jar", null)));
        Path newPomPath = repoRoot.resolve(this.repositoryManager.getPathForLocalArtifact(request, artifact.asArtifactCoordinate(newAId, "pom", null)));
        Path oldJarPath = repoRoot.resolve(this.repositoryManager.getPathForLocalArtifact(request, artifact.asArtifactCoordinate(artifact.artifactId, "jar", "tests")));
        Path oldPomPath = repoRoot.resolve(this.repositoryManager.getPathForLocalArtifact(request, artifact.asArtifactCoordinate(artifact.artifactId, "pom", null)));
        LocalRepoArtifact localRepoArtifact = new LocalRepoArtifact(artifact, newAId, Files.exists(newJarPath, new LinkOption[0]) && Files.exists(newPomPath, new LinkOption[0]), newJarPath, newPomPath, oldJarPath, oldPomPath);
        return localRepoArtifact;
    }

    private void install(InstallableArtifact installable) throws MojoExecutionException {
        try {
            Files.createDirectories(installable.local.newLocalRepoJarPath.getParent(), new FileAttribute[0]);
            Files.copy(installable.local.oldLocalRepoJarPath, installable.local.newLocalRepoJarPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy from " + installable.local.oldLocalRepoJarPath + " to " + installable.local.newLocalRepoJarPath, e);
        }
        try {
            Files.createDirectories(installable.local.newLocalRepoPomPath.getParent(), new FileAttribute[0]);
            Files.copy(installable.sourcePomPath, installable.local.newLocalRepoPomPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy from " + installable.sourcePomPath + " to " + installable.local.newLocalRepoPomPath, e);
        }
    }

    static String anyNs(String ... elements) {
        StringBuilder sb = new StringBuilder();
        for (String e : elements) {
            sb.append("/*[local-name()='").append(e).append("']");
        }
        return sb.toString();
    }

    static Node textElement(Document document, String elementName, String value) {
        Element result = document.createElement(elementName);
        result.appendChild(document.createTextNode(value));
        return result;
    }

    private InstallableArtifact transform(LocalRepoArtifact localRepoArtifact) {
        Gav artifact = localRepoArtifact.artifact;
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            XPath xPath = XPathFactory.newInstance().newXPath();
            this.getLog().warn((CharSequence)("Transforming " + artifact));
            Path pomPath = localRepoArtifact.oldLocalRepoPomPath;
            DOMResult result = new DOMResult();
            try (BufferedReader r = Files.newBufferedReader(pomPath);){
                t.transform(new StreamSource(r), result);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read " + pomPath, e);
            }
            catch (TransformerException e) {
                throw new RuntimeException("Could not transform to DOM: " + pomPath, e);
            }
            Document doc = (Document)result.getNode();
            Node artifactNode = (Node)xPath.evaluate(RepackageAndInstallTestJarsMojo.anyNs("project", "artifactId"), doc, XPathConstants.NODE);
            String oldArtifactId = artifactNode.getTextContent();
            artifactNode.setTextContent(localRepoArtifact.newArtifactId);
            Node nameNode = (Node)xPath.evaluate(RepackageAndInstallTestJarsMojo.anyNs("project", "name"), doc, XPathConstants.NODE);
            if (nameNode != null) {
                nameNode.setTextContent(nameNode.getTextContent() + " - Tests");
            }
            this.remove(xPath, RepackageAndInstallTestJarsMojo.anyNs("project", "description"), doc);
            NodeList deps = (NodeList)xPath.evaluate(RepackageAndInstallTestJarsMojo.anyNs("project", "dependencies", "dependency"), doc, XPathConstants.NODESET);
            for (int i = 0; i < deps.getLength(); ++i) {
                Node dep = deps.item(i);
                Node scope = (Node)xPath.evaluate("*[local-name()='scope']", dep, XPathConstants.NODE);
                if (scope != null && "test".equals(scope.getTextContent())) {
                    scope.getParentNode().removeChild(scope);
                    continue;
                }
                dep.getParentNode().removeChild(dep);
            }
            Node depsNode = (Node)xPath.evaluate(RepackageAndInstallTestJarsMojo.anyNs("project", "dependencies"), doc, XPathConstants.NODE);
            if (depsNode == null) {
                depsNode = doc.createElement("dependencies");
                ((Node)xPath.evaluate(RepackageAndInstallTestJarsMojo.anyNs("project"), doc, XPathConstants.NODE)).appendChild(depsNode);
            }
            Element newDep = doc.createElement("dependency");
            depsNode.appendChild(newDep);
            doc.createElement("dependency");
            newDep.appendChild(RepackageAndInstallTestJarsMojo.textElement(doc, "groupId", artifact.groupId));
            newDep.appendChild(RepackageAndInstallTestJarsMojo.textElement(doc, "artifactId", oldArtifactId));
            newDep.appendChild(RepackageAndInstallTestJarsMojo.textElement(doc, "version", artifact.version));
            this.remove(xPath, RepackageAndInstallTestJarsMojo.anyNs("project", "build"), doc);
            this.remove(xPath, RepackageAndInstallTestJarsMojo.anyNs("project", "profiles"), doc);
            Path testsPom = this.workDir.toPath().resolve(localRepoArtifact.newArtifactId + "-" + artifact.version + ".pom");
            Files.createDirectories(testsPom.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(testsPom, new OpenOption[0]);){
                t.transform(new DOMSource(doc), new StreamResult(w));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write " + testsPom, e);
            }
            catch (TransformerException e) {
                throw new RuntimeException("Could not serialize DOM: " + testsPom, e);
            }
            return new InstallableArtifact(localRepoArtifact, testsPom);
        }
        catch (IOException | TransformerConfigurationException | TransformerFactoryConfigurationError | XPathExpressionException | DOMException e) {
            throw new RuntimeException("Could not transform " + artifact, e);
        }
    }

    private void remove(XPath xPath, String xPathExpression, Document doc) throws XPathExpressionException {
        Node node = (Node)xPath.evaluate(xPathExpression, doc, XPathConstants.NODE);
        if (node != null) {
            node.getParentNode().removeChild(node);
        }
    }

    private void download(LocalRepoArtifact localRepoArtifact) throws MojoFailureException {
        try {
            Iterable resolvedArtifacts = this.dependencyResolver.resolveDependencies(this.session.getProjectBuildingRequest(), localRepoArtifact.artifact.asDependableCoordinate(), null);
            boolean jarDownloaded = false;
            for (ArtifactResult ar : resolvedArtifacts) {
                if (!ar.getArtifact().getFile().toPath().equals(localRepoArtifact.oldLocalRepoJarPath)) continue;
                jarDownloaded = true;
                break;
            }
            if (Files.exists(localRepoArtifact.oldLocalRepoJarPath, new LinkOption[0])) {
                jarDownloaded = true;
            }
            if (!jarDownloaded) {
                throw new IllegalStateException("Could not assert that " + localRepoArtifact.artifact + ":jar was downloaded as " + localRepoArtifact.oldLocalRepoJarPath);
            }
        }
        catch (DependencyResolverException e) {
            throw new MojoFailureException("Could not download " + localRepoArtifact.artifact, (Throwable)e);
        }
    }

    public static class InstallableArtifact {
        private final LocalRepoArtifact local;
        private final Path sourcePomPath;

        public InstallableArtifact(LocalRepoArtifact local, Path pomPath) {
            this.local = local;
            this.sourcePomPath = pomPath;
        }
    }

    public static class LocalRepoArtifact {
        private final Gav artifact;
        private final boolean installed;
        private final Path newLocalRepoJarPath;
        private final Path newLocalRepoPomPath;
        private final Path oldLocalRepoJarPath;
        private final Path oldLocalRepoPomPath;
        private final String newArtifactId;

        public LocalRepoArtifact(Gav artifact, String newArtifactId, boolean installed, Path newLocalRepoJarPath, Path newLocalRepoPomPath, Path oldLocalRepoJarPath, Path oldLocalRepoPomPath) {
            this.artifact = artifact;
            this.newArtifactId = newArtifactId;
            this.installed = installed;
            this.newLocalRepoJarPath = newLocalRepoJarPath;
            this.newLocalRepoPomPath = newLocalRepoPomPath;
            this.oldLocalRepoJarPath = oldLocalRepoJarPath;
            this.oldLocalRepoPomPath = oldLocalRepoPomPath;
        }
    }
}

