/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.rpkgtests;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.l2x6.rpkgtests.Ga;
import org.l2x6.rpkgtests.Gas;
import org.l2x6.rpkgtests.Gav;

@Mojo(name="create-test-jars-file", requiresDependencyResolution=ResolutionScope.NONE, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class CreateTestJarsXmlMojo
extends AbstractMojo {
    @Parameter(property="rpkgtests.testJarsPath", defaultValue="${project.build.directory}/${project.artifactId}.xml")
    private File testJarsPath;
    @Parameter(property="rpkgtests.fileSets")
    private FileSet[] fileSets;
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File baseDir;
    @Parameter(property="rpkgtests.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Charset charset = this.encoding != null ? Charset.forName(this.encoding) : StandardCharsets.UTF_8;
        TreeSet<Path> pomPaths = new TreeSet<Path>();
        FileSetManager fileSetManager = new FileSetManager();
        for (FileSet fs : this.fileSets) {
            String[] includedFiles;
            Path dir = Paths.get(fs.getDirectory(), new String[0]);
            for (String includedFile : includedFiles = fileSetManager.getIncludedFiles(fs)) {
                pomPaths.add(dir.resolve(includedFile));
            }
        }
        ArrayList<Ga> gas = new ArrayList<Ga>();
        for (Path pomPath : pomPaths) {
            gas.add(Ga.read(pomPath, charset));
        }
        Path outputPath = this.baseDir.toPath().resolve(this.testJarsPath.toPath());
        try {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create " + outputPath.getParent(), (Exception)e);
        }
        try (BufferedWriter w = Files.newBufferedWriter(outputPath, charset, new OpenOption[0]);){
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{Gas.class, Gav.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)new Gas(gas), (Writer)w);
        }
        catch (JAXBException e) {
            throw new MojoExecutionException("Could not serialize testJars " + gas, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write to " + outputPath, (Exception)e);
        }
    }
}

