/*
 * Decompiled with CFR 0.152.
 */
package org.kyojo.minion;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import org.kyojo.gson.Gson;
import org.kyojo.gson.GsonBuilder;
import org.kyojo.gson.reflect.TypeToken;
import org.kyojo.minion.SuperclassExclusionStrategy;
import org.kyojo.modeshape.common.text.Inflector;

public final class My {
    public static String MYHS_SALT = "qgCYkPcrMl5WK2vK3VJF";
    protected static Gson gson;

    private static Properties searchProperties() {
        try {
            URL rscUrl = My.class.getResource("My.properties");
            if (rscUrl != null) {
                InputStream is = rscUrl.openStream();
                Properties props = new Properties();
                props.load(is);
                is.close();
                return props;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return null;
    }

    public static String hs(String str) {
        return My.hs(str, null);
    }

    public static String hs(String str, String charsetName) {
        if (str == null || str.equals("")) {
            return "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            if (charsetName == null) {
                md.update((MYHS_SALT + str).getBytes());
            } else {
                md.update((MYHS_SALT + str).getBytes(charsetName));
            }
            return My.bin2HexStr(md.digest());
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new RuntimeException(nsae);
        }
        catch (UnsupportedEncodingException nee) {
            nee.printStackTrace();
            throw new RuntimeException(nee);
        }
    }

    public static String bin2HexStr(byte[] bin) {
        StringBuilder sb = new StringBuilder();
        int len = bin.length;
        for (int i = 0; i < len; ++i) {
            int val = bin[i] & 0xFF;
            if (val < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(val));
        }
        return sb.toString();
    }

    public static String minion(Object var) {
        return gson.toJson(var);
    }

    public static <T> T deminion(String str, Type type) {
        return gson.fromJson(str, type);
    }

    public static String tableize(String word) {
        if (word == null) {
            return null;
        }
        Inflector inflector = Inflector.getInstance();
        return inflector.underscore(word.replaceAll("\\.", "__"), new char[0]);
    }

    public static String pascalize(String word) {
        if (word == null) {
            return null;
        }
        Inflector inflector = Inflector.getInstance();
        StringBuilder sb = new StringBuilder();
        for (String elem : word.split("__|\\.")) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(inflector.upperCamelCase(elem, new char[0]));
        }
        return sb.toString();
    }

    public static String camelize(String word) {
        if (word == null) {
            return null;
        }
        Inflector inflector = Inflector.getInstance();
        StringBuilder sb = new StringBuilder();
        for (String elem : word.split("__|\\.")) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(inflector.lowerCamelCase(elem, new char[0]));
        }
        return sb.toString();
    }

    public static String constantize(String word) {
        if (word == null) {
            return null;
        }
        return My.tableize(word).toUpperCase();
    }

    public static String magicalize(String word) {
        if (word == null) {
            return null;
        }
        return "__" + My.constantize(word) + "__";
    }

    static {
        try {
            GsonBuilder builder = new GsonBuilder();
            Properties props = My.searchProperties();
            if (props != null) {
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    if (entry.getKey().toString().equals("MYHS_SALT")) {
                        MYHS_SALT = entry.getValue().toString();
                        continue;
                    }
                    System.out.println(entry.getKey().toString() + "=" + entry.getValue().toString());
                    if (entry.getKey().toString().indexOf(",") < 0) {
                        Class<?> ifcCls = My.class.getClassLoader().loadClass(entry.getKey().toString());
                        Class<?> crtrCls = My.class.getClassLoader().loadClass(entry.getValue().toString());
                        builder.registerTypeAdapter(ifcCls, crtrCls.newInstance());
                        continue;
                    }
                    String[] ifcClsNames = entry.getKey().toString().split(",");
                    Class<?> ifcCls1 = My.class.getClassLoader().loadClass(ifcClsNames[0]);
                    Class<?> ifcCls2 = My.class.getClassLoader().loadClass(ifcClsNames[1]);
                    Type listType = TypeToken.getParameterized(ifcCls1, ifcCls2).getType();
                    Class<?> crtrCls = My.class.getClassLoader().loadClass(entry.getValue().toString());
                    builder.registerTypeAdapter(listType, crtrCls.newInstance());
                }
            }
            gson = builder.setExclusionStrategies(new SuperclassExclusionStrategy()).create();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
    }
}

