/*
 * Decompiled with CFR 0.152.
 */
package org.kyojo.gson.internal.bind;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.kyojo.gson.Gson;
import org.kyojo.gson.JsonElement;
import org.kyojo.gson.JsonElementKeyComparator;
import org.kyojo.gson.JsonPrimitive;
import org.kyojo.gson.JsonSyntaxException;
import org.kyojo.gson.TypeAdapter;
import org.kyojo.gson.TypeAdapterFactory;
import org.kyojo.gson.internal.$Gson$Types;
import org.kyojo.gson.internal.ConstructorConstructor;
import org.kyojo.gson.internal.JsonReaderInternalAccess;
import org.kyojo.gson.internal.ObjectConstructor;
import org.kyojo.gson.internal.Streams;
import org.kyojo.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import org.kyojo.gson.internal.bind.TypeAdapters;
import org.kyojo.gson.reflect.TypeToken;
import org.kyojo.gson.stream.JsonReader;
import org.kyojo.gson.stream.JsonToken;
import org.kyojo.gson.stream.JsonWriter;

public final class MapTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    final boolean complexMapKeySerialization;

    public MapTypeAdapterFactory(ConstructorConstructor constructorConstructor, boolean complexMapKeySerialization) {
        this.constructorConstructor = constructorConstructor;
        this.complexMapKeySerialization = complexMapKeySerialization;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        if (!Map.class.isAssignableFrom(rawType)) {
            return null;
        }
        Class<?> rawTypeOfSrc = $Gson$Types.getRawType(type);
        Type[] keyAndValueTypes = $Gson$Types.getMapKeyAndValueTypes(type, rawTypeOfSrc);
        TypeAdapter<?> keyAdapter = this.getKeyAdapter(gson, keyAndValueTypes[0]);
        TypeAdapter<?> valueAdapter = gson.getAdapter(TypeToken.get(keyAndValueTypes[1]));
        ObjectConstructor<T> constructor = this.constructorConstructor.get(typeToken);
        Adapter result = new Adapter(gson, keyAndValueTypes[0], keyAdapter, keyAndValueTypes[1], valueAdapter, constructor);
        return result;
    }

    private TypeAdapter<?> getKeyAdapter(Gson context, Type keyType) {
        return keyType == Boolean.TYPE || keyType == Boolean.class ? TypeAdapters.BOOLEAN_AS_STRING : context.getAdapter(TypeToken.get(keyType));
    }

    private final class Adapter<K, V>
    extends TypeAdapter<Map<K, V>> {
        private final TypeAdapter<K> keyTypeAdapter;
        private final TypeAdapter<V> valueTypeAdapter;
        private final ObjectConstructor<? extends Map<K, V>> constructor;

        public Adapter(Gson context, Type keyType, TypeAdapter<K> keyTypeAdapter, Type valueType, TypeAdapter<V> valueTypeAdapter, ObjectConstructor<? extends Map<K, V>> constructor) {
            this.keyTypeAdapter = new TypeAdapterRuntimeTypeWrapper<K>(context, keyTypeAdapter, keyType);
            this.valueTypeAdapter = new TypeAdapterRuntimeTypeWrapper<V>(context, valueTypeAdapter, valueType);
            this.constructor = constructor;
        }

        @Override
        public Map<K, V> read(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Map<K, V> map = this.constructor.construct();
            if (peek == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    in.beginArray();
                    K key = this.keyTypeAdapter.read(in);
                    V value = this.valueTypeAdapter.read(in);
                    V replaced = map.put(key, value);
                    if (replaced != null) {
                        throw new JsonSyntaxException("duplicate key: " + key);
                    }
                    in.endArray();
                }
                in.endArray();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    V value;
                    JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                    K key = this.keyTypeAdapter.read(in);
                    V replaced = map.put(key, value = this.valueTypeAdapter.read(in));
                    if (replaced == null) continue;
                    throw new JsonSyntaxException("duplicate key: " + key);
                }
                in.endObject();
            }
            return map;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Map<K, V> map) throws IOException {
            JsonElement keyElement;
            if (map == null) {
                out.nullValue();
                return;
            }
            if (!MapTypeAdapterFactory.this.complexMapKeySerialization) {
                HashMap<K, String> kStrs = new HashMap<K, String>();
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    kStrs.put(entry.getKey(), String.valueOf(entry.getKey()));
                }
                LinkedList kKeys = new LinkedList(kStrs.entrySet());
                Collections.sort(kKeys, new Comparator<Map.Entry<K, String>>(){

                    @Override
                    public int compare(Map.Entry<K, String> e1, Map.Entry<K, String> e2) {
                        return e1.getValue().compareTo(e2.getValue());
                    }
                });
                out.beginObject();
                for (Map.Entry entry : kKeys) {
                    out.name(String.valueOf(entry.getValue()));
                    this.valueTypeAdapter.write(out, map.get(entry.getKey()));
                }
                out.endObject();
                return;
            }
            boolean hasComplexKeys = false;
            ArrayList<JsonElement> jeKeys = new ArrayList<JsonElement>(map.size());
            ArrayList<V> arrayList = new ArrayList<V>(map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                keyElement = this.keyTypeAdapter.toJsonTree(entry.getKey());
                jeKeys.add(keyElement);
                arrayList.add(entry.getValue());
                hasComplexKeys |= keyElement.isJsonArray() || keyElement.isJsonObject();
            }
            Collections.sort(jeKeys, new JsonElementKeyComparator());
            if (hasComplexKeys) {
                void var6_13;
                out.beginArray();
                boolean bl = false;
                int size = jeKeys.size();
                while (var6_13 < size) {
                    out.beginArray();
                    Streams.write((JsonElement)jeKeys.get((int)var6_13), out);
                    this.valueTypeAdapter.write(out, arrayList.get((int)var6_13));
                    out.endArray();
                    ++var6_13;
                }
                out.endArray();
            } else {
                void var6_15;
                out.beginObject();
                boolean bl = false;
                int size = jeKeys.size();
                while (var6_15 < size) {
                    keyElement = (JsonElement)jeKeys.get((int)var6_15);
                    out.name(this.keyToString(keyElement));
                    this.valueTypeAdapter.write(out, arrayList.get((int)var6_15));
                    ++var6_15;
                }
                out.endObject();
            }
        }

        private String keyToString(JsonElement keyElement) {
            if (keyElement.isJsonPrimitive()) {
                JsonPrimitive primitive = keyElement.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    return String.valueOf(primitive.getAsNumber());
                }
                if (primitive.isBoolean()) {
                    return Boolean.toString(primitive.getAsBoolean());
                }
                if (primitive.isString()) {
                    return primitive.getAsString();
                }
                throw new AssertionError();
            }
            if (keyElement.isJsonNull()) {
                return "null";
            }
            throw new AssertionError();
        }
    }
}

