/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.ws;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.JsonElement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.kurento.jsonrpc.JsonRpcException;
import org.kurento.jsonrpc.message.Response;
import org.kurento.jsonrpc.message.ResponseError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingRequests {
    private static final Logger log = LoggerFactory.getLogger(PendingRequests.class);
    private final ConcurrentMap<Integer, SettableFuture<Response<JsonElement>>> pendingRequests = new ConcurrentHashMap<Integer, SettableFuture<Response<JsonElement>>>();

    public void handleResponse(Response<JsonElement> response) {
        SettableFuture responseFuture = (SettableFuture)this.pendingRequests.remove(response.getId());
        if (responseFuture == null) {
            log.error("Received response with an id not registered as pending request");
        } else {
            responseFuture.set(response);
        }
    }

    public ListenableFuture<Response<JsonElement>> prepareResponse(Integer id) {
        Preconditions.checkNotNull((Object)id, (Object)"The request id cannot be null");
        SettableFuture responseFuture = SettableFuture.create();
        if (this.pendingRequests.putIfAbsent(id, (SettableFuture<Response<JsonElement>>)responseFuture) != null) {
            throw new JsonRpcException("Can not send a request with the id '" + id + "'. There is already a pending request with this id");
        }
        return responseFuture;
    }

    public void closeAllPendingRequests() {
        log.info("Sending error to all pending requests");
        for (SettableFuture responseFuture : this.pendingRequests.values()) {
            responseFuture.set(new Response(new ResponseError(0, "Connection with server have been closed")));
        }
        this.pendingRequests.clear();
    }
}

