/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.internal.JsonRpcHandlerManager;
import org.kurento.jsonrpc.internal.JsonRpcRequestSender;
import org.kurento.jsonrpc.internal.JsonRpcRequestSenderHelper;
import org.kurento.jsonrpc.internal.client.ClientSession;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonRpcClient
implements JsonRpcRequestSender,
Closeable {
    public static Logger log = LoggerFactory.getLogger((String)JsonRpcClient.class.getName());
    protected JsonRpcHandlerManager handlerManager = new JsonRpcHandlerManager();
    protected JsonRpcRequestSenderHelper rsHelper;
    protected Object registerInfo;
    protected ClientSession session;
    protected String label = "";
    protected int connectionTimeout = 15000;
    protected int idleTimeout = 300000;
    protected int heartbeatInterval = 0;
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 5000;
    protected boolean heartbeating;
    private boolean closed;
    private volatile PingParams pingParams;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private Future<?> heartbeat;

    public void setServerRequestHandler(JsonRpcHandler<?> handler) {
        this.handlerManager.setJsonRpcHandler(handler);
    }

    public void setLabel(String label) {
        this.label = "[" + label + "] ";
    }

    @Override
    public <R> R sendRequest(String method, Class<R> resultClass) throws IOException {
        return this.rsHelper.sendRequest(method, resultClass);
    }

    @Override
    public <R> R sendRequest(String method, Object params, Class<R> resultClass) throws IOException {
        return this.rsHelper.sendRequest(method, params, resultClass);
    }

    @Override
    public JsonElement sendRequest(String method) throws IOException {
        return this.rsHelper.sendRequest(method);
    }

    @Override
    public JsonElement sendRequest(String method, Object params) throws IOException {
        return this.rsHelper.sendRequest(method, params);
    }

    @Override
    public void sendRequest(String method, JsonObject params, Continuation<JsonElement> continuation) {
        this.rsHelper.sendRequest(method, params, continuation);
    }

    @Override
    public void sendNotification(String method) throws IOException {
        this.rsHelper.sendNotification(method);
    }

    @Override
    public void sendNotification(String method, Object params, Continuation<JsonElement> continuation) throws IOException {
        this.rsHelper.sendNotification(method, params, continuation);
    }

    @Override
    public void sendNotification(String method, Object params) throws IOException {
        this.rsHelper.sendNotification(method, params);
    }

    @Override
    public Response<JsonElement> sendRequest(Request<JsonObject> request) throws IOException {
        return this.rsHelper.sendRequest(request);
    }

    @Override
    public void sendRequest(Request<JsonObject> request, Continuation<Response<JsonElement>> continuation) throws IOException {
        this.rsHelper.sendRequest(request, continuation);
    }

    @Override
    public void sendRequestHonorId(Request<JsonObject> request, Continuation<Response<JsonElement>> continuation) throws IOException {
        this.rsHelper.sendRequestHonorId(request, continuation);
    }

    @Override
    public Response<JsonElement> sendRequestHonorId(Request<JsonObject> request) throws IOException {
        return this.rsHelper.sendRequestHonorId(request);
    }

    public Session getSession() {
        return this.session;
    }

    public void setSessionId(String sessionId) {
        this.rsHelper.setSessionId(sessionId);
        this.session.setSessionId(sessionId);
    }

    public int getConnectionTimeoutValue() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeoutValue(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(int interval) {
        this.heartbeatInterval = interval;
    }

    public void enableHeartbeat() {
        if (this.heartbeatInterval == 0) {
            this.heartbeatInterval = 5000;
        }
        this.enableHeartbeat(this.heartbeatInterval);
    }

    public synchronized void enableHeartbeat(int interval) {
        if (this.heartbeat == null || this.heartbeat.isCancelled()) {
            this.pingParams = new PingParams();
            this.pingParams.interval = interval;
            log.debug("{} Enabling heartbeat with an interval of {} ms", (Object)this.label, (Object)interval);
            this.heartbeating = true;
            this.heartbeatInterval = interval;
            if (this.scheduler.isShutdown()) {
                this.scheduler = Executors.newSingleThreadScheduledExecutor();
            }
            this.heartbeat = this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        JsonObject response = JsonRpcClient.this.sendRequest("ping", JsonRpcClient.this.pingParams).getAsJsonObject();
                        JsonRpcClient.this.pingParams = null;
                        if (!"pong".equals(response.get("value").getAsString())) {
                            JsonRpcClient.this.closeHeartbeatOnFailure();
                        }
                    }
                    catch (Exception e) {
                        log.warn("{} Error sending heartbeat to server", (Object)JsonRpcClient.this.label, (Object)e);
                        JsonRpcClient.this.closeHeartbeatOnFailure();
                    }
                }
            }, 0L, this.heartbeatInterval, TimeUnit.MILLISECONDS);
        }
    }

    private final void closeHeartbeatOnFailure() {
        log.warn("{} Stopping heartbeat and closing client: failure during heartbeat mechanism", (Object)this.label);
        this.heartbeat.cancel(false);
        this.heartbeat = null;
        this.scheduler.shutdownNow();
        try {
            this.closeWithReconnection();
        }
        catch (IOException e) {
            log.warn("{} Exception while closing client: {}", (Object)this.label, (Object)e.getMessage());
        }
    }

    public void disableHeartbeat() {
        if (this.heartbeating) {
            this.heartbeating = false;
            if (this.heartbeat != null) {
                this.heartbeat.cancel(false);
                this.heartbeat = null;
            }
            this.scheduler.shutdownNow();
        }
    }

    public abstract void connect() throws IOException;

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    protected void closeWithReconnection() throws IOException {
        this.close();
    }

    public abstract void setRequestTimeout(long var1);

    public boolean isClosed() {
        return this.closed;
    }

    private static class PingParams {
        public long interval;

        private PingParams() {
        }
    }
}

