/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kurento.jsonrpc.JsonPropsAdapter;
import org.kurento.jsonrpc.JsonRpcException;
import org.kurento.jsonrpc.JsonRpcRequestDeserializer;
import org.kurento.jsonrpc.JsonRpcResponseDeserializer;
import org.kurento.jsonrpc.Props;
import org.kurento.jsonrpc.message.Message;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;

public class JsonUtils {
    public static final boolean INJECT_SESSION_ID = true;
    private static Gson gson;

    public static String toJson(Object obj) {
        return JsonUtils.getGson().toJson(obj);
    }

    public static JsonObject toJsonObject(Object obj) {
        return JsonUtils.fromJson(JsonUtils.getGson().toJson(obj), JsonObject.class);
    }

    public static Message fromJsonMessage(String message) {
        JsonObject json = JsonUtils.fromJson(message, JsonObject.class);
        if (json.has("method")) {
            return JsonUtils.fromJsonRequest(json, JsonObject.class);
        }
        return JsonUtils.fromJsonResponse(json, JsonElement.class);
    }

    public static <T> Request<T> fromJsonRequest(String json, Class<T> paramsClass) {
        return JsonUtils.fromJsonRequestInject(JsonUtils.fromJson(json, JsonObject.class), paramsClass);
    }

    public static <T> Response<T> fromJsonResponse(String json, Class<T> resultClass) {
        return JsonUtils.fromJsonResponseInject(JsonUtils.fromJson(json, JsonObject.class), resultClass);
    }

    public static <T> Request<T> fromJsonRequest(JsonObject json, Class<T> paramsClass) {
        return JsonUtils.fromJsonRequestInject(json, paramsClass);
    }

    public static <T> Response<T> fromJsonResponse(JsonObject json, Class<T> resultClass) {
        return JsonUtils.fromJsonResponseInject(json, resultClass);
    }

    private static <T> Response<T> fromJsonResponseInject(JsonObject jsonObject, Class<T> resultClass) {
        try {
            String sessionId = JsonUtils.extractSessionId(jsonObject, "result");
            Response response = resultClass != null ? (Response)JsonUtils.fromJson((JsonElement)jsonObject, (Type).Gson.Types.newParameterizedTypeWithOwner(null, Response.class, (Type[])new Type[]{resultClass})) : (Response)JsonUtils.fromJson((JsonElement)jsonObject, (Type).Gson.Types.newParameterizedTypeWithOwner(null, Response.class, (Type[])new Type[]{JsonElement.class}));
            response.setSessionId(sessionId);
            return response;
        }
        catch (JsonSyntaxException e) {
            throw new JsonRpcException("Exception converting Json '" + jsonObject + "' to a JSON-RPC response with params as class " + resultClass.getName(), e);
        }
    }

    private static <T> Request<T> fromJsonRequestInject(JsonObject jsonObject, Class<T> paramsClass) {
        String sessionId = JsonUtils.extractSessionId(jsonObject, "params");
        Request request = (Request)JsonUtils.getGson().fromJson((JsonElement)jsonObject, (Type).Gson.Types.newParameterizedTypeWithOwner(null, Request.class, (Type[])new Type[]{paramsClass}));
        request.setSessionId(sessionId);
        return request;
    }

    private static String extractSessionId(JsonObject jsonObject, String memberName) {
        JsonObject responseJsonObject;
        JsonElement sessionIdJson;
        JsonElement responseJson = jsonObject.get(memberName);
        if (responseJson != null && responseJson.isJsonObject() && (sessionIdJson = (responseJsonObject = (JsonObject)responseJson).remove("sessionId")) != null && !(sessionIdJson instanceof JsonNull)) {
            return sessionIdJson.getAsString();
        }
        return null;
    }

    public static String toJson(Object obj, Type type) {
        return JsonUtils.getGson().toJson(obj, type);
    }

    public static <T> String toJsonRequest(Request<T> request) {
        return JsonUtils.getGson().toJson(request, (Type).Gson.Types.newParameterizedTypeWithOwner(null, Request.class, (Type[])new Type[]{JsonUtils.getClassOrNull(request.getParams())}));
    }

    public static <T> String toJsonResponse(Response<T> request) {
        return JsonUtils.getGson().toJson(request, (Type).Gson.Types.newParameterizedTypeWithOwner(null, Response.class, (Type[])new Type[]{JsonUtils.getClassOrNull(request.getResult())}));
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)JsonUtils.getGson().fromJson(json, clazz);
    }

    public static <T> T fromJson(JsonElement json, Class<T> clazz) {
        return (T)JsonUtils.getGson().fromJson(json, clazz);
    }

    public static <T> T fromJson(String json, Type type) {
        return (T)JsonUtils.getGson().fromJson(json, type);
    }

    public static <T> T fromJson(JsonElement json, Type type) {
        return (T)JsonUtils.getGson().fromJson(json, type);
    }

    private static Class<?> getClassOrNull(Object object) {
        return object == null ? null : object.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Gson getGson() {
        if (gson != null) return gson;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            if (gson != null) return gson;
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(Request.class, (Object)new JsonRpcRequestDeserializer());
            builder.registerTypeAdapter(Response.class, (Object)new JsonRpcResponseDeserializer());
            builder.registerTypeAdapter(Props.class, (Object)new JsonPropsAdapter());
            builder.disableHtmlEscaping();
            gson = builder.create();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gson;
        }
    }

    static boolean isIn(JsonObject jObject, String[] clues) {
        for (String clue : clues) {
            if (!jObject.has(clue)) continue;
            return true;
        }
        return false;
    }

    public static String toJsonMessage(Message message) {
        if (message.getSessionId() != null) {
            Response response;
            JsonObject jsonObject = JsonUtils.toJsonObject(message);
            JsonObject objectToInjectSessionId = message instanceof Request ? JsonUtils.convertToObject(jsonObject, "params") : ((response = (Response)message).getError() == null ? JsonUtils.convertToObject(jsonObject, "result") : JsonUtils.convertToObject(jsonObject, "error", "data"));
            objectToInjectSessionId.addProperty("sessionId", message.getSessionId());
            return jsonObject.toString();
        }
        return JsonUtils.toJson(message);
    }

    private static JsonObject convertToObject(JsonObject jsonObject, String ... properties) {
        String property = properties[0];
        JsonElement paramsJson = jsonObject.get(property);
        JsonObject paramsAsObject = null;
        if (paramsJson == null) {
            paramsAsObject = new JsonObject();
            jsonObject.add(property, (JsonElement)paramsAsObject);
            paramsJson = paramsAsObject;
        }
        if (!paramsJson.isJsonObject()) {
            paramsAsObject = new JsonObject();
            paramsAsObject.add("value", paramsJson);
            jsonObject.add(property, (JsonElement)paramsAsObject);
        } else {
            paramsAsObject = (JsonObject)paramsJson;
        }
        if (properties.length > 1) {
            JsonUtils.convertToObject(jsonObject, Arrays.copyOfRange(properties, 1, properties.length));
        }
        return paramsAsObject;
    }

    public static JsonElement toJsonElement(Object object) {
        return JsonUtils.getGson().toJsonTree(object);
    }

    public static <E> E extractJavaValueFromResult(JsonElement result, Type type) {
        if (type == Void.class || type == Void.TYPE) {
            return null;
        }
        JsonElement extractResult = JsonUtils.extractJsonValueFromResponse(result, type);
        return (E)JsonUtils.fromJson(extractResult, type);
    }

    private static JsonElement extractJsonValueFromResponse(JsonElement result, Type type) {
        if (result == null) {
            return null;
        }
        if (JsonUtils.isPrimitiveClass(type) || JsonUtils.isEnum(type)) {
            if (result instanceof JsonPrimitive) {
                return result;
            }
            if (result instanceof JsonArray) {
                throw new JsonRpcException("Json array '" + result + " cannot be converted to " + JsonUtils.getTypeName(type));
            }
            if (result instanceof JsonObject) {
                return JsonUtils.extractSimpleValueFromJsonObject((JsonObject)result, type);
            }
            throw new JsonRpcException("Unrecognized json element: " + result);
        }
        if (JsonUtils.isList(type)) {
            if (result instanceof JsonArray) {
                return result;
            }
            return JsonUtils.extractSimpleValueFromJsonObject((JsonObject)result, type);
        }
        return result;
    }

    private static JsonElement extractSimpleValueFromJsonObject(JsonObject result, Type type) {
        if (!result.has("value")) {
            throw new JsonRpcException("Json object " + result + " cannot be converted to " + JsonUtils.getTypeName(type) + " without a 'value' property");
        }
        return result.get("value");
    }

    private static boolean isEnum(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isEnum();
        }
        return false;
    }

    private static boolean isPrimitiveClass(Type type) {
        return type == String.class || type == Void.class || type == Void.TYPE || type == Boolean.class || type == Boolean.TYPE || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Float.class || type == Float.TYPE || type == Double.class || type == Double.TYPE;
    }

    private static boolean isList(Type type) {
        ParameterizedType pType;
        if (type == List.class) {
            return true;
        }
        if (type instanceof ParameterizedType && (pType = (ParameterizedType)type).getRawType() instanceof Class) {
            return ((Class)pType.getRawType()).isAssignableFrom(List.class);
        }
        return false;
    }

    private static String getTypeName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            StringBuilder sb = new StringBuilder();
            ParameterizedType pType = (ParameterizedType)type;
            Class rawClass = (Class)pType.getRawType();
            sb.append(rawClass.getSimpleName());
            Type[] arguments = pType.getActualTypeArguments();
            if (arguments.length > 0) {
                sb.append('<');
                for (Type aType : arguments) {
                    sb.append(JsonUtils.getTypeName(aType));
                    sb.append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append('>');
            }
            return sb.toString();
        }
        return type.toString();
    }

    public static List<String> toStringList(JsonArray values) {
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement element : values) {
            if (element instanceof JsonPrimitive) {
                list.add(((JsonPrimitive)element).getAsString());
                continue;
            }
            throw new JsonParseException("JsonArray " + values + " contains non string elements");
        }
        return list;
    }
}

