/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal;

import java.io.IOException;
import java.io.InputStream;

public final class ProtocolUtils {
    private static final String UTF8 = "UTF-8";
    private static final String UTF16BE = "UTF-16BE";
    private static final String UTF16LE = "UTF-16LE";
    private static final String UTF32BE = "UTF-32BE";
    private static final String UTF32LE = "UTF-32LE";

    public static String detectJsonEncoding(InputStream inputStream) throws IOException {
        int r;
        inputStream.mark(4);
        int mask = 0;
        for (int count = 0; count < 4 && (r = inputStream.read()) != -1; ++count) {
            mask <<= 1;
            mask |= r == 0 ? 0 : 1;
        }
        inputStream.reset();
        return ProtocolUtils.match(mask);
    }

    private static String match(int mask) {
        switch (mask) {
            case 1: {
                return UTF32BE;
            }
            case 5: {
                return UTF16BE;
            }
            case 8: {
                return UTF32LE;
            }
            case 10: {
                return UTF16LE;
            }
            case 15: {
                return UTF8;
            }
        }
        return null;
    }
}

