/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.kurento.jsonrpc.JsonRpcException;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.internal.JsonRpcRequestSender;
import org.kurento.jsonrpc.internal.client.AbstractSession;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;

public class ClientSession
extends AbstractSession {
    private final JsonRpcRequestSender requestSender;
    private volatile ConcurrentMap<String, Object> attributes;

    public ClientSession(String sessionId, Object registerInfo, JsonRpcRequestSender jsonRpcRequestSender) {
        super(sessionId, registerInfo);
        this.requestSender = jsonRpcRequestSender;
    }

    @Override
    public void close() throws IOException {
        if (this.requestSender instanceof JsonRpcClient) {
            ((JsonRpcClient)this.requestSender).close();
        }
    }

    @Override
    public <R> R sendRequest(String method, Class<R> resultClass) throws IOException {
        return this.requestSender.sendRequest(method, resultClass);
    }

    @Override
    public <R> R sendRequest(String method, Object params, Class<R> resultClass) throws IOException {
        return this.requestSender.sendRequest(method, params, resultClass);
    }

    @Override
    public JsonElement sendRequest(String method) throws IOException {
        return this.requestSender.sendRequest(method);
    }

    @Override
    public JsonElement sendRequest(String method, Object params) throws IOException {
        return this.requestSender.sendRequest(method, params);
    }

    @Override
    public void sendNotification(String method, Object params) throws IOException {
        this.requestSender.sendNotification(method, params);
    }

    @Override
    public void sendNotification(String method) throws IOException {
        this.requestSender.sendNotification(method);
    }

    @Override
    public void sendRequest(String method, JsonObject params, Continuation<JsonElement> continuation) {
        this.requestSender.sendRequest(method, params, continuation);
    }

    @Override
    public void sendNotification(String method, Object params, Continuation<JsonElement> continuation) throws IOException {
        this.requestSender.sendNotification(method, params, continuation);
    }

    @Override
    public Response<JsonElement> sendRequest(Request<JsonObject> request) throws IOException {
        return this.requestSender.sendRequest(request);
    }

    @Override
    public void sendRequest(Request<JsonObject> request, Continuation<Response<JsonElement>> continuation) throws IOException {
        this.requestSender.sendRequest(request, continuation);
    }

    @Override
    public void setReconnectionTimeout(long millis) {
        throw new JsonRpcException("Reconnection timeout can't be configured in the client");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            ClientSession clientSession = this;
            synchronized (clientSession) {
                if (this.attributes == null) {
                    this.attributes = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.attributes;
    }
}

