/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.jsonrpc.JsonRpcErrorException;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.message.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveManager {
    public static final String KEEP_ALIVE_INTERVAL_TIME_PROPERTY = "keepAliveIntervalTime";
    private static final int KEEP_ALIVE_TIME_DEFAULT_VALUE = 120000;
    private static final Object DUMMY_OBJECT_FOR_MAP = new Object();
    private static Logger log = LoggerFactory.getLogger(KeepAliveManager.class);
    private JsonRpcClient client;
    private long keepAliveIntervalTime;
    private Mode mode;
    private ConcurrentHashMap<String, Object> ids = new ConcurrentHashMap();
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public KeepAliveManager(JsonRpcClient client, long keepAliveIntervalTime) {
        this(client, keepAliveIntervalTime, Mode.PER_CLIENT);
    }

    public KeepAliveManager(JsonRpcClient client, Mode mode) {
        this(client, -1L, mode);
    }

    public KeepAliveManager(JsonRpcClient client, long keepAliveIntervalTime, Mode mode) {
        this.client = client;
        this.mode = mode;
        this.keepAliveIntervalTime = keepAliveIntervalTime != -1L ? keepAliveIntervalTime : (long)PropertiesManager.getProperty((String)KEEP_ALIVE_INTERVAL_TIME_PROPERTY, (int)120000);
    }

    public void start() {
        log.debug("Configured keepAliveManager to send keepAlives each " + this.keepAliveIntervalTime + " millis");
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    KeepAliveManager.this.sendKeepAlives();
                }
                catch (Throwable t) {
                    log.warn("Exception sending keepAlive.", t);
                }
            }
        }, this.keepAliveIntervalTime, this.keepAliveIntervalTime, TimeUnit.MILLISECONDS);
    }

    protected void sendKeepAlives() {
        if (this.mode == Mode.PER_ID_AS_SESSION) {
            for (String id : this.ids.keySet()) {
                JsonObject params = new JsonObject();
                params.addProperty("object", id);
                try {
                    this.client.sendRequest("keepAlive", params);
                }
                catch (IOException e) {
                    log.error("Exception while sending keepAlive from mediaPipeline " + id, (Throwable)e);
                }
            }
        } else if (this.mode == Mode.PER_ID_AS_MEDIAPIPELINE) {
            for (String id : this.ids.keySet()) {
                JsonObject params = new JsonObject();
                params.addProperty("object", id);
                try {
                    this.client.sendRequest(new Request<JsonObject>(id, null, "keepAlive", params));
                }
                catch (JsonRpcErrorException e) {
                    log.warn("Error while sending keepAlive for MediaPipeline '{}': {}. Removing this MediaPipeline from keepAlive list.", (Object)id, (Object)e.getMessage());
                }
                catch (IOException e) {
                    log.error("Exception while sending keepAlive from mediaPipeline " + id, (Throwable)e);
                }
            }
        } else if (this.mode == Mode.PER_CLIENT) {
            try {
                this.client.sendRequest("keepAlive", null);
            }
            catch (IOException e) {
                throw new KurentoException("Exception while sending keepAlive from session " + this.client.getSession().getSessionId());
            }
        } else {
            throw new KurentoException("Unrecognized keepAlive mode = " + (Object)((Object)this.mode));
        }
        log.debug("Finish sending keepAlives");
    }

    public void addId(String id) {
        this.ids.put(id, DUMMY_OBJECT_FOR_MAP);
    }

    public void removeId(String id) {
        this.ids.remove(id);
    }

    public void stop() {
        this.executor.shutdown();
    }

    public static enum Mode {
        PER_CLIENT,
        PER_ID_AS_SESSION,
        PER_ID_AS_MEDIAPIPELINE;

    }
}

