/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.client;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.Transaction;
import org.kurento.jsonrpc.client.RequestAlreadyRespondedException;
import org.kurento.jsonrpc.message.Message;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.kurento.jsonrpc.message.ResponseError;

public class TransactionImpl
implements Transaction {
    private final Session session;
    private boolean async;
    private final AtomicBoolean responded = new AtomicBoolean(false);
    private final ResponseSender responseSender;
    private final Request<?> request;

    public TransactionImpl(Session session, Request<?> request, ResponseSender responseSender) {
        this.session = session;
        this.responseSender = responseSender;
        this.request = request;
    }

    @Override
    public void sendResponse(Object result) throws IOException {
        this.internalSendResponse(new Response<Object>(this.request.getId(), result));
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void startAsync() {
        this.async = true;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean setRespondedIfNot() {
        return this.responded.compareAndSet(false, true);
    }

    @Override
    public void sendError(int code, String message, String data) throws IOException {
        this.internalSendResponse(new Response(this.request.getId(), new ResponseError(code, message, data)));
    }

    @Override
    public void sendError(Throwable e) throws IOException {
        ResponseError error = ResponseError.newFromException(e);
        this.internalSendResponse(new Response(this.request.getId(), error));
    }

    @Override
    public boolean isNotification() {
        return this.request.getId() == null;
    }

    @Override
    public void sendResponseObject(Response<? extends Object> response) throws IOException {
        this.internalSendResponse(response);
    }

    private void internalSendResponse(Response<? extends Object> response) throws IOException {
        boolean notResponded = this.setRespondedIfNot();
        if (notResponded) {
            if (response.getSessionId() == null) {
                response.setSessionId(this.session.getSessionId());
            }
            if (response.getId() == null) {
                response.setId(this.request.getId());
            }
        } else {
            throw new RequestAlreadyRespondedException("This request has already been responded");
        }
        this.responseSender.sendResponse(response);
    }

    @Override
    public void sendVoidResponse() throws IOException {
        this.sendResponse(null);
    }

    public static interface ResponseSender {
        public void sendResponse(Message var1) throws IOException;
    }
}

