/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.kurento.jsonrpc.message.Response;
import org.kurento.jsonrpc.message.ResponseError;

class JsonRpcResponseDeserializer
implements JsonDeserializer<Response<?>> {
    JsonRpcResponseDeserializer() {
    }

    public Response<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Integer id;
        if (!(json instanceof JsonObject)) {
            throw new JsonParseException("JonObject expected, found " + json.getClass().getSimpleName());
        }
        JsonObject jObject = (JsonObject)json;
        if (!jObject.has("jsonrpc")) {
            throw new JsonParseException("Invalid JsonRpc response lacking version 'jsonrpc' field");
        }
        if (!jObject.get("jsonrpc").getAsString().equals("2.0")) {
            throw new JsonParseException("Invalid JsonRpc version");
        }
        try {
            id = jObject.get("id").getAsInt();
        }
        catch (Exception e) {
            throw new JsonParseException("Invalid JsonRpc response. It lacks a valid 'id' field");
        }
        if (jObject.has("result")) {
            ParameterizedType parameterizedType = (ParameterizedType)typeOfT;
            return new Response<Object>(id, context.deserialize(jObject.get("result"), parameterizedType.getActualTypeArguments()[0]));
        }
        if (jObject.has("error")) {
            return new Response(id, (ResponseError)context.deserialize(jObject.get("error"), ResponseError.class));
        }
        throw new JsonParseException("Invalid JsonRpc response. It lacks a valid 'result' or 'error' field");
    }
}

