/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.message;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.kurento.jsonrpc.JsonRpcErrorException;

public class ResponseError {
    private Integer code;
    private String message;
    private JsonElement data;

    public static ResponseError newFromException(Throwable e) {
        return ResponseError.newFromException(-1, e);
    }

    public static ResponseError newFromException(int requestId, Throwable e) {
        if (e instanceof JsonRpcErrorException) {
            JsonRpcErrorException jsonRpcError = (JsonRpcErrorException)((Object)e);
            return new ResponseError(jsonRpcError.getCode(), jsonRpcError.getMessage(), jsonRpcError.getData());
        }
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return new ResponseError(requestId, e.getClass().getSimpleName() + ":" + e.getMessage(), writer.toString());
    }

    public ResponseError() {
    }

    public ResponseError(int code, String message, String data) {
        this.code = code;
        this.message = message;
        if (data != null) {
            this.data = new JsonPrimitive(data);
        }
    }

    public ResponseError(int code, String message, JsonElement data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public ResponseError(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code != null ? this.code : 0;
    }

    void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    public String getData() {
        if (this.data instanceof JsonPrimitive) {
            return ((JsonPrimitive)this.data).getAsString();
        }
        if (this.data != null) {
            return this.data.toString();
        }
        return null;
    }

    void setData(String data) {
        this.data = new JsonPrimitive(data);
    }
}

