/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.ws;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import org.apache.http.concurrent.BasicFuture;
import org.kurento.jsonrpc.JsonRpcException;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingRequests {
    private static final Logger log = LoggerFactory.getLogger(PendingRequests.class);
    private final ConcurrentMap<Integer, BasicFuture<Response<JsonElement>>> pendingRequests = new ConcurrentHashMap<Integer, BasicFuture<Response<JsonElement>>>();

    public void handleResponse(Response<JsonElement> response) {
        BasicFuture responseFuture = (BasicFuture)this.pendingRequests.remove(response.getId());
        if (responseFuture == null) {
            log.error("Received response with an id not registered as pending request");
        } else {
            responseFuture.completed(response);
        }
    }

    public Future<Response<JsonElement>> prepareResponse(Integer id) {
        Preconditions.checkNotNull((Object)id, (Object)"The request id cannot be null");
        BasicFuture responseFuture = new BasicFuture(null);
        if (this.pendingRequests.putIfAbsent(id, (BasicFuture<Response<JsonElement>>)responseFuture) != null) {
            throw new JsonRpcException("Can not send a request with the id '" + id + "'. There is already a pending request with this id");
        }
        return responseFuture;
    }
}

