/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.KeepAliveManager;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.internal.JsonRpcHandlerManager;
import org.kurento.jsonrpc.internal.JsonRpcRequestSender;
import org.kurento.jsonrpc.internal.JsonRpcRequestSenderHelper;
import org.kurento.jsonrpc.internal.client.ClientSession;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;

public abstract class JsonRpcClient
implements JsonRpcRequestSender,
Closeable {
    protected JsonRpcHandlerManager handlerManager = new JsonRpcHandlerManager();
    protected JsonRpcRequestSenderHelper rsHelper;
    protected Object registerInfo;
    protected ClientSession session;
    protected KeepAliveManager keepAliveManager;

    public void setServerRequestHandler(JsonRpcHandler<?> handler) {
        this.handlerManager.setJsonRpcHandler(handler);
    }

    @Override
    public abstract void close() throws IOException;

    @Override
    public <R> R sendRequest(String method, Class<R> resultClass) throws IOException {
        return this.rsHelper.sendRequest(method, resultClass);
    }

    @Override
    public <R> R sendRequest(String method, Object params, Class<R> resultClass) throws IOException {
        return this.rsHelper.sendRequest(method, params, resultClass);
    }

    @Override
    public JsonElement sendRequest(String method) throws IOException {
        return this.rsHelper.sendRequest(method);
    }

    @Override
    public JsonElement sendRequest(String method, Object params) throws IOException {
        return this.rsHelper.sendRequest(method, params);
    }

    @Override
    public void sendRequest(String method, JsonObject params, Continuation<JsonElement> continuation) {
        this.rsHelper.sendRequest(method, params, continuation);
    }

    @Override
    public void sendNotification(String method) throws IOException {
        this.rsHelper.sendNotification(method);
    }

    @Override
    public void sendNotification(String method, Object params, Continuation<JsonElement> continuation) throws IOException {
        this.rsHelper.sendNotification(method, params, continuation);
    }

    @Override
    public void sendNotification(String method, Object params) throws IOException {
        this.rsHelper.sendNotification(method, params);
    }

    @Override
    public Response<JsonElement> sendRequest(Request<JsonObject> request) throws IOException {
        return this.rsHelper.sendRequest(request);
    }

    @Override
    public void sendRequest(Request<JsonObject> request, Continuation<Response<JsonElement>> continuation) throws IOException {
        this.rsHelper.sendRequest(request, continuation);
    }

    public Session getSession() {
        return this.session;
    }

    public void setSessionId(String sessionId) {
        this.rsHelper.setSessionId(sessionId);
        this.session.setSessionId(sessionId);
    }

    public KeepAliveManager getKeepAliveManager() {
        return this.keepAliveManager;
    }

    public void setKeepAliveManager(KeepAliveManager keepAliveManager) {
        this.keepAliveManager = keepAliveManager;
    }
}

