/*
 * Decompiled with CFR 0.152.
 */
package org.kubek2k.springockito.annotations;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.kubek2k.springockito.annotations.ReplaceWithMock;
import org.kubek2k.springockito.annotations.internal.DesiredMockitoBeansFinder;
import org.kubek2k.springockito.annotations.internal.definer.MockitoBeansDefiner;
import org.kubek2k.springockito.annotations.internal.definer.MockitoSpiesDefiner;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.support.GenericXmlContextLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringockitoContextLoader
extends GenericXmlContextLoader {
    private Map<String, DesiredMockitoBeansFinder.MockProperties<ReplaceWithMock>> mockedBeans = new TreeMap<String, DesiredMockitoBeansFinder.MockProperties<ReplaceWithMock>>();
    private Set<String> spiedBeans = new TreeSet<String>();
    private DesiredMockitoBeansFinder mockedBeansFinder = new DesiredMockitoBeansFinder();
    private MockitoBeansDefiner mockitoBeansDefiner = new MockitoBeansDefiner();
    private MockitoSpiesDefiner mockitoSpiesDefiner = new MockitoSpiesDefiner();

    protected void customizeContext(GenericApplicationContext context) {
        super.customizeContext(context);
        this.registerMocks(context, this.mockedBeans);
        this.registerSpies(context, this.spiedBeans);
    }

    private void registerMocks(GenericApplicationContext context, Map<String, DesiredMockitoBeansFinder.MockProperties<ReplaceWithMock>> mockedBeans) {
        for (Map.Entry<String, DesiredMockitoBeansFinder.MockProperties<ReplaceWithMock>> beanEntry : this.mockedBeans.entrySet()) {
            DesiredMockitoBeansFinder.MockProperties<ReplaceWithMock> mockProperties = beanEntry.getValue();
            ReplaceWithMock replaceWithMockAnnotation = mockProperties.getAnnotationInstance();
            context.registerBeanDefinition(beanEntry.getKey(), (BeanDefinition)this.mockitoBeansDefiner.createMockFactoryBeanDefinition(mockProperties.getMockClass(), replaceWithMockAnnotation.extraInterfaces(), replaceWithMockAnnotation.name(), replaceWithMockAnnotation.defaultAnswer()));
        }
    }

    private void registerSpies(GenericApplicationContext context, Set<String> spiedBeanNames) {
        for (String beanName : spiedBeanNames) {
            BeanDefinition beanDefinition = context.getBeanDefinition(beanName);
            String wrappedBeanName = beanName + "$$WRAPPED_WITH_SPY";
            context.registerBeanDefinition(wrappedBeanName, beanDefinition);
            context.registerBeanDefinition(beanName, (BeanDefinition)this.mockitoSpiesDefiner.createSpyDefinition(wrappedBeanName));
        }
    }

    private void defineMocksAndSpies(Class<?> clazz) {
        this.mockedBeans.putAll(this.mockedBeansFinder.findMockedBeans(clazz));
        this.spiedBeans.addAll(this.mockedBeansFinder.findSpiedBeans(clazz));
    }

    protected String[] generateDefaultLocations(Class<?> clazz) {
        String[] resultingLocations = super.generateDefaultLocations(clazz);
        this.defineMocksAndSpies(clazz);
        return resultingLocations;
    }

    protected String[] modifyLocations(Class<?> clazz, String ... passedLocations) {
        String[] resultingLocations = super.modifyLocations(clazz, passedLocations);
        this.defineMocksAndSpies(clazz);
        return resultingLocations;
    }
}

