/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.xml.spring;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Properties;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.properties.spring.EnvironmentPropertySourceConfig;
import org.kuali.common.util.runonce.smart.RunOnce;
import org.kuali.common.util.runonce.smart.RunOnceExecutable;
import org.kuali.common.util.spring.SpringExecUtils;
import org.kuali.common.util.spring.SpringExecutable;
import org.kuali.common.util.spring.event.ApplicationEventListenerConfig;
import org.kuali.common.util.spring.event.ExecutableApplicationEventListener;
import org.kuali.common.util.spring.service.SpringService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.xml.ingest.ParameterServiceRunOnce;
import org.kuali.rice.xml.spring.IngestXmlExecConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.env.PropertySource;

@Configuration
@Import(value={SpringServiceConfig.class, EnvironmentPropertySourceConfig.class})
public class IngestXmlRunOnceConfig
implements ApplicationEventListenerConfig {
    private static final String ORDER_KEY = "rice.ingest.order";
    private static final String NAMESPACE_KEY = "rice.ingest.param.namespace";
    private static final String COMPONENT_KEY = "rice.ingest.param.component";
    private static final String NAME_KEY = "rice.ingest.param.name";
    private static final String DESCRIPTION_KEY = "rice.ingest.param.description";
    private static final String RUN_ON_MISSING_PARAMETER_KEY = "rice.ingest.runOnMissingParameter";
    private static final String NAMESPACE = "KR-WKFLW";
    private static final String COMPONENT = "All";
    private static final String NAME = "INGEST_XML_AT_STARTUP_IND";
    private static final String DESCRIPTION = "Set this to 'Y' to ingest XML documents at application startup";
    private static final Boolean RUN_ON_MISSING_PARAMETER = Boolean.FALSE;
    @Autowired
    SpringService service;
    @Autowired
    PropertySource<?> propertySource;

    @Bean
    public SmartApplicationListener applicationEventListener() {
        Properties properties = ConfigContext.getCurrentContextConfig().getProperties();
        String applicationId = properties.getProperty("application.id");
        String namespace = properties.getProperty(NAMESPACE_KEY, NAMESPACE);
        String component = properties.getProperty(COMPONENT_KEY, COMPONENT);
        String name = properties.getProperty(NAME_KEY, NAME);
        String description = properties.getProperty(DESCRIPTION_KEY, DESCRIPTION);
        boolean runOnMissingParameter = Boolean.parseBoolean(properties.getProperty(RUN_ON_MISSING_PARAMETER_KEY, RUN_ON_MISSING_PARAMETER.toString()));
        int order = Integer.parseInt(properties.getProperty(ORDER_KEY, String.valueOf(Integer.MAX_VALUE)));
        ParameterServiceRunOnce runOnce = ParameterServiceRunOnce.builder(applicationId, namespace, component, name).description(description).runOnMissingParameter(runOnMissingParameter).build();
        SpringExecutable springExecutable = SpringExecUtils.getSpringExecutable((SpringService)this.service, this.propertySource, IngestXmlExecConfig.class, (List)Lists.newArrayList((Object[])new String[]{"master"}));
        RunOnceExecutable executable = RunOnceExecutable.builder((Executable)springExecutable, (RunOnce)runOnce).build();
        return ExecutableApplicationEventListener.builder((Executable)executable, ContextRefreshedEvent.class).order(order).build();
    }
}

