/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.xml.ingest;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.log.LoggerUtils;
import org.kuali.common.util.runonce.smart.RunOnce;
import org.kuali.common.util.runonce.smart.RunOnceState;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.api.parameter.ParameterContract;
import org.kuali.rice.coreservice.api.parameter.ParameterType;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.slf4j.Logger;

public final class ParameterServiceRunOnce
implements RunOnce {
    private static final Logger logger = LoggerUtils.make();
    private static final String CONFIGURATION_PARAMETER_TYPE = "CONFG";
    private static final String YES = "Y";
    private ParameterService parameterService;
    private final String applicationId;
    private final String namespace;
    private final String component;
    private final String name;
    private final Optional<String> description;
    private final boolean runOnMissingParameter;
    private boolean initialized;
    private boolean runonce;

    public synchronized void initialize() {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Already initialized");
        this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        Optional parameter = Optional.fromNullable((Object)this.parameterService.getParameter(this.namespace, this.component, this.name));
        if (!parameter.isPresent() && this.runOnMissingParameter) {
            parameter = Optional.of((Object)this.createParameter());
        }
        this.runonce = this.isRunOnce((Optional<Parameter>)parameter);
        this.showConfig((Optional<Parameter>)parameter);
        this.initialized = true;
    }

    public synchronized boolean isTrue() {
        Preconditions.checkState((boolean)this.initialized, (Object)"Not initialized");
        return this.runonce;
    }

    public synchronized void changeState(RunOnceState state) {
        Preconditions.checkState((boolean)this.initialized, (Object)"Not initialized");
        Preconditions.checkNotNull((Object)state, (Object)"'state' cannot be null");
        Parameter existingParameter = this.parameterService.getParameter(this.namespace, this.component, this.name);
        Preconditions.checkNotNull((Object)existingParameter, (Object)"'existingParameter' cannot be null");
        logger.info("Updating parameter: [{}]", (Object)this.name);
        Parameter.Builder builder = Parameter.Builder.create((ParameterContract)existingParameter);
        builder.setValue(state.name());
        Parameter updatedParameter = this.parameterService.updateParameter(builder.build());
        this.runonce = this.isRunOnce(updatedParameter);
        Preconditions.checkState((!this.isTrue() ? 1 : 0) != 0, (Object)"isTrue() must return false");
        logger.info("Transitioned RunOnce to - [{}]", (Object)updatedParameter.getValue());
    }

    private boolean isRunOnce(Optional<Parameter> parameter) {
        return parameter.isPresent() && this.isRunOnce((Parameter)parameter.get());
    }

    private boolean isRunOnce(Parameter parameter) {
        return Truth.strToBooleanIgnoreCase((String)parameter.getValue(), (Boolean)Boolean.FALSE);
    }

    private Parameter createParameter() {
        logger.info("Creating parameter: [{}]=[{}]", (Object)this.name, (Object)YES);
        ParameterType.Builder parameterTypeBuilder = ParameterType.Builder.create((String)CONFIGURATION_PARAMETER_TYPE);
        Parameter.Builder parameterBuilder = Parameter.Builder.create((String)this.applicationId, (String)this.namespace, (String)this.component, (String)this.name, (ParameterType.Builder)parameterTypeBuilder);
        parameterBuilder.setValue(YES);
        if (this.description.isPresent()) {
            parameterBuilder.setDescription((String)this.description.get());
        }
        return this.parameterService.createParameter(parameterBuilder.build());
    }

    private void showConfig(Optional<Parameter> optional) {
        logger.info(String.format("Parameter Metadata: [%s:%s:%s]", this.applicationId, this.namespace, this.component));
        if (optional.isPresent()) {
            Parameter parameter = (Parameter)optional.get();
            logger.info("Parameter: [{}]=[{}]", (Object)this.name, (Object)parameter.getValue());
        } else {
            logger.info("Parameter [{}] does not exist", (Object)this.name);
        }
        logger.info("RunOnce: [{}]", (Object)this.runonce);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getComponent() {
        return this.component;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    private ParameterServiceRunOnce(Builder builder) {
        this.applicationId = builder.applicationId;
        this.namespace = builder.namespace;
        this.component = builder.component;
        this.name = builder.name;
        this.description = builder.description;
        this.runOnMissingParameter = builder.runOnMissingParameter;
    }

    public static Builder builder(String applicationId, String namespace, String component, String name) {
        return new Builder(applicationId, namespace, component, name);
    }

    public static class Builder {
        private String applicationId;
        private String namespace;
        private String component;
        private String name;
        private Optional<String> description = Optional.absent();
        private boolean runOnMissingParameter;

        public Builder(String applicationId, String namespace, String component, String name) {
            this.applicationId = applicationId;
            this.namespace = namespace;
            this.component = component;
            this.name = name;
        }

        public Builder description(String description) {
            this.description = Optional.fromNullable((Object)description);
            return this;
        }

        public Builder runOnMissingParameter(boolean runOnMissingParameter) {
            this.runOnMissingParameter = runOnMissingParameter;
            return this;
        }

        public ParameterServiceRunOnce build() {
            ParameterServiceRunOnce instance = new ParameterServiceRunOnce(this);
            Builder.validate(instance);
            return instance;
        }

        private static void validate(ParameterServiceRunOnce instance) {
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)instance.getApplicationId()) ? 1 : 0) != 0, (Object)"'application' id cannot be null");
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)instance.getNamespace()) ? 1 : 0) != 0, (Object)"'namespace' cannot be null");
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)instance.getComponent()) ? 1 : 0) != 0, (Object)"'component' cannot be null");
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)instance.getName()) ? 1 : 0) != 0, (Object)"'name' cannot be null");
            Preconditions.checkNotNull(instance.getDescription(), (Object)"'description' cannot be null");
        }
    }
}

