/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.deploy.spring;

import java.util.ArrayList;
import java.util.List;
import org.kuali.common.deploy.env.model.DeployEnvironment;
import org.kuali.common.deploy.env.spring.DefaultDeployEnvironmentConfig;
import org.kuali.common.deploy.env.spring.DeployEnvironmentConfig;
import org.kuali.common.deploy.project.DeployProjectConstants;
import org.kuali.common.jdbc.project.spring.JdbcProjectConfig;
import org.kuali.common.jdbc.project.spring.JdbcPropertyLocationsConfig;
import org.kuali.common.util.Assert;
import org.kuali.common.util.Mode;
import org.kuali.common.util.project.ProjectService;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.model.ProjectIdentifier;
import org.kuali.common.util.project.spring.AutowiredProjectConfig;
import org.kuali.common.util.project.spring.ProjectServiceConfig;
import org.kuali.common.util.properties.Location;
import org.kuali.common.util.properties.PropertiesLocationService;
import org.kuali.common.util.properties.PropertiesService;
import org.kuali.common.util.properties.spring.DefaultPropertiesServiceConfig;
import org.kuali.common.util.properties.spring.PropertiesLocationServiceConfig;
import org.kuali.common.util.property.PropertyFormat;
import org.kuali.common.util.spring.PropertySourceUtils;
import org.kuali.common.util.spring.service.PropertySourceConfig;
import org.kuali.rice.deploy.RiceDeployProjectConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.PropertySource;

@Configuration
@Import(value={JdbcProjectConfig.class, JdbcPropertyLocationsConfig.class, DefaultPropertiesServiceConfig.class, PropertiesLocationServiceConfig.class, AutowiredProjectConfig.class, DefaultDeployEnvironmentConfig.class, ProjectServiceConfig.class})
public class DeployPSC
implements PropertySourceConfig {
    private static final ProjectIdentifier DEPLOY = DeployProjectConstants.ID;
    @Autowired
    JdbcPropertyLocationsConfig jdbc;
    @Autowired
    PropertiesService service;
    @Autowired
    PropertiesLocationService locationService;
    @Autowired
    Project project;
    @Autowired
    ProjectService projectService;
    @Autowired
    DeployEnvironmentConfig deployEnvConfig;

    @Bean
    public PropertySource<?> propertySource() {
        DeployEnvironment deployEnv = this.deployEnvConfig.deployEnvironment();
        List jdbcLocations = this.jdbc.jdbcPropertyLocations();
        Location branchLoc = this.getOptionalLocation(RiceDeployProjectConstants.ID, "deploy.properties");
        String groupCode = this.project.getProperties().getProperty("project.groupId.code");
        Assert.noBlanks((String[])new String[]{groupCode});
        Location appLoc = this.getOptionalLocation(DEPLOY, groupCode + "/" + this.project.getArtifactId() + ".properties");
        Location envLoc = this.getOptionalLocation(DEPLOY, groupCode + "/" + deployEnv.getName() + ".properties");
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.addAll(jdbcLocations);
        locations.addAll(this.getKualiDeployLocs());
        locations.add(branchLoc);
        locations.add(appLoc);
        locations.add(envLoc);
        return PropertySourceUtils.getPropertySource((PropertiesService)this.service, locations);
    }

    protected Location getOptionalLocation(ProjectIdentifier pid, String filename) {
        String value = ProjectUtils.getClasspathPrefix((ProjectIdentifier)pid) + "/" + filename;
        Project project = this.projectService.getProject(pid);
        String encoding = ProjectUtils.getEncoding((Project)project);
        return new Location(value, encoding, Mode.INFORM, PropertyFormat.NORMAL, true);
    }

    protected List<Location> getKualiDeployLocs() {
        ArrayList<Location> locs = new ArrayList<Location>();
        locs.add(this.getKualiDeployLoc("common.properties"));
        locs.add(this.getKualiDeployLoc("appdynamics.properties"));
        locs.add(this.getKualiDeployLoc("aws.properties"));
        locs.add(this.getKualiDeployLoc("tomcat.properties"));
        locs.add(this.getKualiDeployLoc("db.properties"));
        locs.add(this.getKualiDeployLoc("rice/common.properties"));
        locs.add(this.getKualiDeployLoc("rice/db.properties"));
        locs.add(this.getKualiDeployLoc("rice/aws.properties"));
        locs.add(this.getKualiDeployLoc("rice/appdynamics.properties"));
        return locs;
    }

    protected Location getKualiDeployLoc(String filename) {
        return this.locationService.getLocation(DEPLOY, filename);
    }
}

