/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sql;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.mojo.sql.Fileset;
import org.codehaus.mojo.sql.Order;
import org.codehaus.mojo.sql.SqlResource;
import org.codehaus.mojo.sql.SqlSplitter;
import org.codehaus.plexus.util.FileUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExecMojo
extends AbstractMojo {
    public static final String ON_ERROR_ABORT = "abort";
    public static final String ON_ERROR_ABORT_AFTER = "abortAfter";
    public static final String ON_ERROR_CONTINUE = "continue";
    private boolean showSql;
    private String username;
    private String password;
    private boolean enableAnonymousPassword;
    private String driverProperties;
    private Settings settings;
    private String settingsKey;
    private boolean skipOnConnectionError;
    private boolean forceMojoExecution;
    protected MavenProject project;
    private MavenSession mavenSession;
    private String sqlCommand = "";
    private File[] srcFiles;
    private String resourceListingLocation;
    private String[] resourceLocations;
    private Fileset fileset;
    private boolean skip;
    private String url;
    private String driver;
    private boolean autocommit;
    private String onError = "abort";
    private String delimiter = ";";
    private String delimiterType = "normal";
    private Order orderFile;
    @Deprecated
    private boolean enableBlockMode = false;
    private boolean keepFormat = false;
    private boolean printResultSet = false;
    private boolean showheaders = true;
    private File outputFile;
    private String outputDelimiter;
    private String encoding = "";
    private boolean append = false;
    private boolean escapeProcessing = true;
    private int successfulStatements = 0;
    private int totalStatements = 0;
    private Connection conn = null;
    private Statement statement = null;
    protected Vector<Transaction> transactions = new Vector();
    private MavenFileFilter fileFilter;
    private boolean enableFiltering;
    private boolean executeTrailingSQL;

    public Transaction createTransaction() {
        Transaction t = new Transaction();
        this.transactions.addElement(t);
        return t;
    }

    public void addText(String sql) {
        this.sqlCommand = this.sqlCommand + sql;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiterType(String delimiterType) {
        this.delimiterType = delimiterType;
    }

    @Deprecated
    public void setPrintResutlSet(boolean print) {
        this.setPrintResultSet(print);
    }

    public void setPrintResultSet(boolean print) {
        this.printResultSet = print;
    }

    public void setShowheaders(boolean showheaders) {
        this.showheaders = showheaders;
    }

    public void setOutputFile(File output) {
        this.outputFile = output;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setKeepFormat(boolean keepformat) {
        this.keepFormat = keepformat;
    }

    public void setEscapeProcessing(boolean enable) {
        this.escapeProcessing = enable;
    }

    protected boolean skipMojo() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip sql execution");
            return true;
        }
        if (!this.forceMojoExecution && this.project != null && "pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping sql execution for project with packaging type 'pom'");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.skipMojo()) {
            return;
        }
        this.successfulStatements = 0;
        this.totalStatements = 0;
        this.loadUserInfoFromSettings();
        this.addCommandToTransactions();
        this.addFilesToTransactions();
        this.addFileSetToTransactions();
        this.addResourcesToTransactions();
        this.sortTransactions();
        try {
            this.conn = this.getConnection();
        }
        catch (SQLException e) {
            if (!this.skipOnConnectionError) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            return;
        }
        try {
            this.statement = this.conn.createStatement();
            this.statement.setEscapeProcessing(this.escapeProcessing);
            PrintStream out = System.out;
            try {
                if (this.outputFile != null) {
                    this.getLog().debug((CharSequence)("Opening PrintStream to output file " + this.outputFile));
                    out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.outputFile.getAbsolutePath(), this.append)));
                }
                Enumeration<Transaction> e = this.transactions.elements();
                while (e.hasMoreElements()) {
                    Transaction t = e.nextElement();
                    t.runTransaction(out);
                    if (this.autocommit) continue;
                    this.getLog().debug((CharSequence)"Committing transaction");
                    this.conn.commit();
                }
            }
            finally {
                if (out != null && out != System.out) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (SQLException e) {
            if (!this.autocommit && this.conn != null && ON_ERROR_ABORT.equalsIgnoreCase(this.getOnError())) {
                try {
                    this.conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException ex) {}
        }
        this.getLog().info((CharSequence)(this.getSuccessfulStatements() + " of " + this.getTotalStatements() + " SQL statements executed successfully"));
        if (ON_ERROR_ABORT_AFTER.equalsIgnoreCase(this.getOnError()) && this.totalStatements != this.successfulStatements) {
            throw new MojoExecutionException("Some SQL statements failed to execute");
        }
    }

    private void addCommandToTransactions() {
        this.createTransaction().addText(this.sqlCommand.trim());
    }

    private void addFileSetToTransactions() {
        String[] includedFiles;
        if (this.fileset != null) {
            this.fileset.scan();
            includedFiles = this.fileset.getIncludedFiles();
        } else {
            includedFiles = new String[]{};
        }
        for (int j = 0; j < includedFiles.length; ++j) {
            this.createTransaction().setSrc(new File(this.fileset.getBasedir(), includedFiles[j]));
        }
    }

    protected SqlResource[] getResources(String[] locations, String resourceListingLocation) throws MojoExecutionException {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        if (StringUtils.isBlank((String)resourceListingLocation)) {
            return this.getResources(locations);
        }
        Resource resource = loader.getResource(resourceListingLocation);
        if (!resource.exists()) {
            throw new MojoExecutionException("Resource [" + resourceListingLocation + "] was not found");
        }
        this.getLog().info((CharSequence)("Examining [" + this.getURL(resource) + "]"));
        List<String> locs = this.readLines(resource);
        if (locations == null) {
            locs = this.trim(locs);
            this.getLog().info((CharSequence)("Found " + locs.size() + " locations"));
            return this.getResources(locs.toArray(new String[locs.size()]));
        }
        for (String location : locations) {
            locs.add(location);
        }
        locs = this.trim(locs);
        return this.getResources(locs.toArray(new String[locs.size()]));
    }

    protected URL getURL(Resource resource) {
        try {
            return resource.getURL();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unexpected IO error", e);
        }
    }

    protected List<String> trim(List<String> lines) {
        ArrayList<String> trimmed = new ArrayList<String>();
        for (String line : lines) {
            trimmed.add(StringUtils.trim((String)line));
        }
        return trimmed;
    }

    protected List<String> readLines(Resource resource) {
        InputStream in = null;
        try {
            in = resource.getInputStream();
            if (StringUtils.isBlank((String)this.encoding)) {
                List list = IOUtils.readLines((InputStream)in);
                return list;
            }
            List list = IOUtils.readLines((InputStream)in, (String)this.encoding);
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    protected SqlResource[] getResources(String[] locations) throws MojoExecutionException {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        if (locations == null || locations.length == 0) {
            return new SqlResource[0];
        }
        ArrayList<SqlResource> resources = new ArrayList<SqlResource>();
        for (int i = 0; i < locations.length; ++i) {
            String location = locations[i];
            if (StringUtils.isEmpty((String)location)) continue;
            Resource resource = loader.getResource(location);
            if (!resource.exists()) {
                throw new MojoExecutionException("Resource " + location + " was not found");
            }
            SqlResource sqlResource = new SqlResource();
            sqlResource.setLocation(location);
            sqlResource.setResource(resource);
            resources.add(sqlResource);
        }
        return resources.toArray(new SqlResource[resources.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(Resource resource, File file) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = resource.getInputStream();
            out = new FileOutputStream(file);
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    protected void addResourcesToTransactions() throws MojoExecutionException {
        String[] locations = this.getResourceLocations();
        SqlResource[] resources = this.getResources(locations, this.resourceListingLocation);
        MavenFileFilterRequest request = new MavenFileFilterRequest();
        request.setEncoding(this.encoding);
        request.setMavenSession(this.mavenSession);
        request.setMavenProject(this.project);
        request.setFiltering(this.enableFiltering);
        for (int i = 0; i < resources.length; ++i) {
            SqlResource resource = resources[i];
            if (!this.enableFiltering) {
                this.createTransaction().setResource(resource);
                continue;
            }
            String filename = resource.getResource().getFilename();
            String basename = FileUtils.basename((String)filename);
            String extension = FileUtils.extension((String)filename);
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            File sourceFile = FileUtils.createTempFile((String)basename, (String)extension, null);
            if (!this.getLog().isDebugEnabled()) {
                sourceFile.deleteOnExit();
            }
            try {
                this.copy(resource.getResource(), sourceFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying resource " + resource.getResource() + " to a local temporary file", (Exception)e);
            }
            if (!this.enableFiltering) {
                this.createTransaction().setSrc(sourceFile);
                continue;
            }
            File targetFile = FileUtils.createTempFile((String)basename, (String)extension, null);
            if (!this.getLog().isDebugEnabled()) {
                sourceFile.deleteOnExit();
            }
            request.setFrom(sourceFile);
            request.setTo(targetFile);
            try {
                this.fileFilter.copyFile(request);
            }
            catch (MavenFilteringException e) {
                throw new MojoExecutionException(e.getMessage());
            }
            this.createTransaction().setSrc(targetFile);
        }
    }

    private void addFilesToTransactions() throws MojoExecutionException {
        File[] files = this.getSrcFiles();
        MavenFileFilterRequest request = new MavenFileFilterRequest();
        request.setEncoding(this.encoding);
        request.setMavenSession(this.mavenSession);
        request.setMavenProject(this.project);
        request.setFiltering(this.enableFiltering);
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i] != null && !files[i].exists()) {
                throw new MojoExecutionException(files[i].getPath() + " not found.");
            }
            if (!this.enableFiltering) {
                this.createTransaction().setSrc(files[i]);
                continue;
            }
            File sourceFile = files[i];
            String basename = FileUtils.basename((String)sourceFile.getName());
            String extension = FileUtils.extension((String)sourceFile.getName());
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            File targetFile = FileUtils.createTempFile((String)basename, (String)extension, null);
            if (!this.getLog().isDebugEnabled()) {
                targetFile.deleteOnExit();
            }
            request.setFrom(sourceFile);
            request.setTo(targetFile);
            try {
                this.fileFilter.copyFile(request);
            }
            catch (MavenFilteringException e) {
                throw new MojoExecutionException(e.getMessage());
            }
            this.createTransaction().setSrc(targetFile);
        }
    }

    protected void sortTransactions() {
        switch (this.orderFile) {
            case ASCENDING: {
                Collections.sort(this.transactions);
                break;
            }
            case DESCENDING: {
                Collections.sort(this.transactions, Collections.reverseOrder());
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown value for orderFile: " + (Object)((Object)this.orderFile));
            }
        }
    }

    private void loadUserInfoFromSettings() throws MojoExecutionException {
        Server server;
        if (this.settingsKey == null) {
            this.settingsKey = this.getUrl();
        }
        if ((this.getUsername() == null || this.getPassword() == null) && this.settings != null && (server = this.settings.getServer(this.settingsKey)) != null) {
            if (this.getUsername() == null) {
                this.setUsername(server.getUsername());
            }
            if (this.getPassword() == null) {
                this.setPassword(server.getPassword());
            }
        }
        if (this.getUsername() == null) {
            this.setUsername("");
        }
        if (this.getPassword() == null) {
            this.setPassword("");
        }
    }

    private Connection getConnection() throws MojoExecutionException, SQLException {
        this.getLog().debug((CharSequence)("connecting to " + this.getUrl()));
        Properties properties = this.getProperties();
        Connection conn = this.getDriverInstance().connect(this.getUrl(), properties);
        if (conn == null) {
            throw new SQLException("No suitable Driver for " + this.getUrl());
        }
        conn.setAutoCommit(this.autocommit);
        return conn;
    }

    protected boolean isBlankOrNone(String s) {
        return StringUtils.isBlank((String)s) || "NONE".equals(s.trim());
    }

    protected boolean isSkipPassword() {
        return this.enableAnonymousPassword && this.isBlankOrNone(this.getPassword());
    }

    protected Properties getProperties() throws MojoExecutionException {
        Properties properties = new Properties();
        properties.put("user", this.getUsername());
        if (!this.isSkipPassword()) {
            properties.put("password", this.getPassword());
        }
        properties.putAll((Map<?, ?>)this.getDriverProperties());
        return properties;
    }

    protected Driver getDriverInstance() throws MojoExecutionException {
        try {
            Class<?> dc = Class.forName(this.getDriver());
            return (Driver)dc.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Driver class not found: " + this.getDriver(), (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure loading driver: " + this.getDriver(), e);
        }
    }

    protected Properties getDriverProperties() throws MojoExecutionException {
        Properties properties = new Properties();
        if (!StringUtils.isEmpty((String)this.driverProperties)) {
            String[] tokens = StringUtils.split((String)this.driverProperties, (String)",");
            for (int i = 0; i < tokens.length; ++i) {
                String[] keyValueTokens = StringUtils.split((String)tokens[i].trim(), (String)"=");
                if (keyValueTokens.length != 2) {
                    throw new MojoExecutionException("Invalid JDBC Driver properties: " + this.driverProperties);
                }
                properties.setProperty(keyValueTokens[0], keyValueTokens[1]);
            }
        }
        return properties;
    }

    private void runStatements(Reader reader, PrintStream out) throws SQLException, IOException {
        String line;
        if (this.enableBlockMode) {
            String line2 = IOUtils.toString((Reader)reader);
            this.execSQL(line2, out);
            return;
        }
        StringBuffer sql = new StringBuffer();
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            String token;
            StringTokenizer st;
            this.getLog().debug((CharSequence)("line='" + line + "'"));
            if (!this.keepFormat) {
                line = line.trim();
            }
            if (!this.keepFormat && (line.startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken()))) continue;
            if (!this.keepFormat) {
                sql.append(" ").append(line);
            } else {
                sql.append("\n").append(line);
            }
            if (!this.keepFormat && SqlSplitter.containsSqlEnd(line, this.delimiter) == -1) {
                sql.append("\n");
            }
            if (!this.isEnd(line)) continue;
            this.execSQL(sql.substring(0, sql.length() - this.delimiter.length()), out);
            sql.setLength(0);
        }
        if (this.executeTrailingSQL && !sql.toString().equals("")) {
            this.execSQL(sql.toString(), out);
        }
    }

    protected boolean isEnd(String line) {
        if (this.delimiterType.equals("row")) {
            return line.trim().equals(this.delimiter);
        }
        int pos = SqlSplitter.containsSqlEnd(line, this.delimiter);
        return this.delimiterType.equals("normal") && pos > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execSQL(String sql, PrintStream out) throws SQLException {
        if ("".equals(sql.trim())) {
            return;
        }
        ResultSet resultSet = null;
        try {
            ++this.totalStatements;
            if (this.showSql) {
                this.getLog().info((CharSequence)("SQL-" + this.totalStatements + ": " + sql));
            } else {
                this.getLog().debug((CharSequence)("SQL-" + this.totalStatements + ": " + sql));
            }
            int updateCountTotal = 0;
            boolean ret = this.statement.execute(sql);
            do {
                if (!ret) {
                    int updateCount = this.statement.getUpdateCount();
                    if (updateCount == -1) continue;
                    updateCountTotal += updateCount;
                    continue;
                }
                resultSet = this.statement.getResultSet();
                if (!this.printResultSet) continue;
                this.printResultSet(resultSet, out);
            } while (ret = this.statement.getMoreResults());
            this.getLog().debug((CharSequence)(updateCountTotal + " rows affected"));
            if (this.printResultSet) {
                StringBuffer line = new StringBuffer();
                line.append(updateCountTotal).append(" rows affected");
                out.println(line);
            }
            for (SQLWarning warning = this.conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                this.getLog().debug((CharSequence)(warning + " sql warning"));
            }
            this.conn.clearWarnings();
            ++this.successfulStatements;
        }
        catch (SQLException e) {
            this.getLog().error((CharSequence)("Failed to execute: " + sql));
            if (ON_ERROR_ABORT.equalsIgnoreCase(this.getOnError())) {
                throw e;
            }
            this.getLog().error((CharSequence)e.toString());
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private void printResultSet(ResultSet rs, PrintStream out) throws SQLException {
        if (rs != null) {
            String columnValue;
            int col;
            boolean first;
            this.getLog().debug((CharSequence)"Processing new result set.");
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            StringBuffer line = new StringBuffer();
            if (this.showheaders) {
                first = true;
                for (col = 1; col <= columnCount; ++col) {
                    columnValue = md.getColumnName(col);
                    if (columnValue != null) {
                        columnValue = columnValue.trim();
                        if (",".equals(this.outputDelimiter)) {
                            columnValue = StringEscapeUtils.escapeCsv((String)columnValue);
                        }
                    }
                    if (first) {
                        first = false;
                    } else {
                        line.append(this.outputDelimiter);
                    }
                    line.append(columnValue);
                }
                out.println(line);
                line = new StringBuffer();
            }
            while (rs.next()) {
                first = true;
                for (col = 1; col <= columnCount; ++col) {
                    columnValue = rs.getString(col);
                    if (columnValue != null) {
                        columnValue = columnValue.trim();
                        if (",".equals(this.outputDelimiter)) {
                            columnValue = StringEscapeUtils.escapeCsv((String)columnValue);
                        }
                    }
                    if (first) {
                        first = false;
                    } else {
                        line.append(this.outputDelimiter);
                    }
                    line.append(columnValue);
                }
                out.println(line);
                line = new StringBuffer();
            }
        }
        out.println();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    void setFileset(Fileset fileset) {
        this.fileset = fileset;
    }

    public File[] getSrcFiles() {
        return this.srcFiles;
    }

    public void setSrcFiles(File[] files) {
        this.srcFiles = files;
    }

    @Deprecated
    int getGoodSqls() {
        return this.getSuccessfulStatements();
    }

    public int getSuccessfulStatements() {
        return this.successfulStatements;
    }

    public int getTotalStatements() {
        return this.totalStatements;
    }

    public String getOnError() {
        return this.onError;
    }

    public void setOnError(String action) {
        if (ON_ERROR_ABORT.equalsIgnoreCase(action)) {
            this.onError = ON_ERROR_ABORT;
        } else if (ON_ERROR_CONTINUE.equalsIgnoreCase(action)) {
            this.onError = ON_ERROR_CONTINUE;
        } else if (ON_ERROR_ABORT_AFTER.equalsIgnoreCase(action)) {
            this.onError = ON_ERROR_ABORT_AFTER;
        } else {
            throw new IllegalArgumentException(action + " is not a valid value for onError, only '" + ON_ERROR_ABORT + "', '" + ON_ERROR_ABORT_AFTER + "', or '" + ON_ERROR_CONTINUE + "'.");
        }
    }

    void setSettings(Settings settings) {
        this.settings = settings;
    }

    void setSettingsKey(String key) {
        this.settingsKey = key;
    }

    void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setDriverProperties(String driverProperties) {
        this.driverProperties = driverProperties;
    }

    public boolean isEnableBlockMode() {
        return this.enableBlockMode;
    }

    public void setEnableBlockMode(boolean enableBlockMode) {
        this.enableBlockMode = enableBlockMode;
    }

    public String getSqlCommand() {
        return this.sqlCommand;
    }

    public void setSqlCommand(String sqlCommand) {
        this.sqlCommand = sqlCommand;
    }

    public Vector<Transaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(Vector<Transaction> transactions) {
        this.transactions = transactions;
    }

    public void setFileFilter(MavenFileFilter filter) {
        this.fileFilter = filter;
    }

    public String[] getResourceLocations() {
        return this.resourceLocations;
    }

    public void setResourceLocations(String[] resourceLocations) {
        this.resourceLocations = resourceLocations;
    }

    public boolean isExecuteTrailingSQL() {
        return this.executeTrailingSQL;
    }

    public void setExecuteTrailingSQL(boolean executeTrailingSQL) {
        this.executeTrailingSQL = executeTrailingSQL;
    }

    public Order getOrderFile() {
        return this.orderFile;
    }

    public void setOrderFile(String orderFile) {
        this.orderFile = Order.valueOf(orderFile.toUpperCase());
    }

    public String getResourceListingLocation() {
        return this.resourceListingLocation;
    }

    public void setResourceListingLocation(String resourceListingLocation) {
        this.resourceListingLocation = resourceListingLocation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Transaction
    implements Comparable<Transaction> {
        protected SqlResource resource = null;
        protected File tSrcFile = null;
        protected String tSqlCommand = "";

        protected Transaction() {
        }

        public void setResource(SqlResource resource) {
            this.resource = resource;
        }

        public void setSrc(File src) {
            this.tSrcFile = src;
        }

        public void addText(String sql) {
            this.tSqlCommand = this.tSqlCommand + sql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTransaction(PrintStream out) throws IOException, SQLException {
            InputStreamReader reader;
            if (this.tSqlCommand.length() != 0) {
                SqlExecMojo.this.getLog().info((CharSequence)"Executing commands");
                SqlExecMojo.this.runStatements(new StringReader(this.tSqlCommand), out);
            }
            if (this.tSrcFile != null) {
                SqlExecMojo.this.getLog().info((CharSequence)("Executing file - " + this.tSrcFile.getAbsolutePath()));
                reader = null;
                reader = StringUtils.isEmpty((String)SqlExecMojo.this.encoding) ? new FileReader(this.tSrcFile) : new InputStreamReader((InputStream)new FileInputStream(this.tSrcFile), SqlExecMojo.this.encoding);
                try {
                    SqlExecMojo.this.runStatements(reader, out);
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            if (this.resource != null) {
                SqlExecMojo.this.getLog().info((CharSequence)("Executing - [" + this.resource.getLocation() + "]"));
                SqlExecMojo.this.getLog().debug((CharSequence)("Location - [" + SqlExecMojo.this.getURL(this.resource.getResource()) + "]"));
                reader = null;
                reader = StringUtils.isEmpty((String)SqlExecMojo.this.encoding) ? new InputStreamReader(this.resource.getResource().getInputStream()) : new InputStreamReader(this.resource.getResource().getInputStream(), SqlExecMojo.this.encoding);
                try {
                    SqlExecMojo.this.runStatements(reader, out);
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
        }

        @Override
        public int compareTo(Transaction transaction) {
            if (transaction.tSrcFile == null) {
                if (this.tSrcFile == null) {
                    return 0;
                }
                return Integer.MAX_VALUE;
            }
            if (this.tSrcFile == null) {
                return Integer.MIN_VALUE;
            }
            return this.tSrcFile.compareTo(transaction.tSrcFile);
        }
    }
}

