/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.mojo.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.kuali.common.threads.ElementHandler;
import org.kuali.common.threads.ExecutionStatistics;
import org.kuali.common.threads.ThreadInvoker;
import org.kuali.maven.common.SiteContext;
import org.kuali.maven.common.UrlBuilder;
import org.kuali.maven.mojo.s3.CloudFrontHtmlGenerator;
import org.kuali.maven.mojo.s3.DefaultSiteContext;
import org.kuali.maven.mojo.s3.ListObjectsContext;
import org.kuali.maven.mojo.s3.ListObjectsContextHandler;
import org.kuali.maven.mojo.s3.S3BucketContext;
import org.kuali.maven.mojo.s3.S3DataConverter;
import org.kuali.maven.mojo.s3.S3Mojo;
import org.kuali.maven.mojo.s3.S3PrefixContext;
import org.kuali.maven.mojo.s3.SimpleFormatter;
import org.kuali.maven.mojo.s3.UpdateDirectoryContext;
import org.kuali.maven.mojo.s3.UpdateDirectoryContextHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateOriginBucketMojo
extends S3Mojo {
    UrlBuilder builder = new UrlBuilder();
    SimpleFormatter formatter = new SimpleFormatter();
    ThreadInvoker invoker = new ThreadInvoker();
    private static final String S3_INDEX_METADATA_KEY = "maven-cloudfront-plugin-index";
    private static final String S3_INDEX_CONTENT_TYPE = "text/html";
    CloudFrontHtmlGenerator generator;
    S3DataConverter converter;
    private List<String> orgPomGavs;
    private int threads;
    private String latestToken;
    private boolean latest;
    private String organizationGroupId;
    private String cacheControl;
    private boolean copyDefaultObjectWithDelimiter;
    private boolean copyDefaultObjectWithoutDelimiter;
    private String css;
    private String fileImage;
    private String directoryImage;
    private String timezone;
    private String dateFormat;
    private String defaultObjectKey;
    private String browseKey;
    private CannedAccessControlList acl;

    protected List<String> getPrefixes(ObjectListing listing, String prefix, String delimiter) {
        List commonPrefixes = listing.getCommonPrefixes();
        List<String> pathPrefixes = this.getPathsToRoot(delimiter, prefix);
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.addAll(commonPrefixes);
        prefixes.addAll(pathPrefixes);
        Collections.sort(prefixes);
        return prefixes;
    }

    protected ObjectListing getObjectListing(S3BucketContext context, ListObjectsRequest request) {
        String prefix = this.getPrefix();
        String bucket = context.getBucket();
        String delimiter = context.getDelimiter();
        Integer maxKeys = context.getMaxKeys();
        long start = System.currentTimeMillis();
        ObjectListing listing = context.getClient().listObjects(request);
        long millis = System.currentTimeMillis() - start;
        this.getLog().info((CharSequence)this.getListMsg(listing.getCommonPrefixes().size(), millis));
        int size = listing.getObjectSummaries().size();
        this.getLog().debug((CharSequence)("Found " + size + " summaries for " + prefix));
        this.getLog().debug((CharSequence)("Found " + listing.getCommonPrefixes().size() + " common prefixes for " + prefix));
        if (listing.isTruncated()) {
            throw new AmazonServiceException("The listing for " + bucket + delimiter + prefix + " exceeded " + maxKeys);
        }
        return listing;
    }

    protected List<ListObjectsContext> getListObjectsContexts(S3BucketContext bucketContext, List<String> prefixes) {
        ArrayList<ListObjectsContext> contexts = new ArrayList<ListObjectsContext>();
        for (String prefix : prefixes) {
            ListObjectsRequest request = this.getListObjectsRequest(bucketContext, prefix);
            ListObjectsContext context = new ListObjectsContext();
            context.setRequest(request);
            context.setBucketContext(bucketContext);
            contexts.add(context);
        }
        return contexts;
    }

    protected ListObjectsRequest getListObjectsRequest(S3BucketContext context, String prefix) {
        String bucket = context.getBucket();
        String delimiter = context.getDelimiter();
        Integer maxKeys = context.getMaxKeys();
        if (prefix.equals(delimiter)) {
            prefix = null;
        }
        return new ListObjectsRequest(bucket, prefix, null, delimiter, maxKeys);
    }

    protected String getListMsg(int subDirectoryCount, long millis) {
        StringBuilder sb = new StringBuilder();
        sb.append("S3 Directories: " + subDirectoryCount);
        sb.append("  Listing Request: " + this.formatter.getTime(millis));
        return sb.toString();
    }

    @Override
    public void executeMojo() throws MojoExecutionException, MojoFailureException {
        try {
            long start = System.currentTimeMillis();
            this.getLog().info((CharSequence)("Updating S3 bucket - " + this.getBucket()));
            this.updateMojoState();
            S3BucketContext context = this.getS3BucketContext();
            this.generator = new CloudFrontHtmlGenerator(context);
            this.converter = new S3DataConverter(context);
            this.converter.setBrowseKey(this.getBrowseKey());
            String prefix = this.getPrefix();
            this.getLog().info((CharSequence)("Re-indexing content for - " + prefix));
            ListObjectsRequest request = this.getListObjectsRequest(context, prefix);
            ObjectListing projectDirectory = this.getObjectListing(context, request);
            List<String> prefixes = this.getPrefixes(projectDirectory, prefix, context.getDelimiter());
            List<ObjectListing> listings = this.getObjectListings(context, prefixes, this.threads);
            listings.add(projectDirectory);
            List<S3PrefixContext> contexts = this.getS3PrefixContexts(context, listings);
            List<UpdateDirectoryContext> udcs = this.getUpdateDirContexts(contexts);
            UpdateDirectoryContextHandler handler = new UpdateDirectoryContextHandler(this);
            ExecutionStatistics stats = this.invoker.invokeThreads(this.threads, (ElementHandler)handler, udcs);
            long millis = stats.getExecutionTime();
            long count = stats.getIterationCount();
            this.getLog().info((CharSequence)("Updated " + count + " bucket keys.  Time: " + this.formatter.getTime(millis)));
            this.getLog().info((CharSequence)("S3 Bucket update complete - " + this.getBucket()));
            this.getLog().info((CharSequence)("Total time: " + this.formatter.getTime(System.currentTimeMillis() - start)));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unexpected error: ", e);
        }
    }

    protected List<ObjectListing> getObjectListings(S3BucketContext context, List<String> prefixes, int maxThreads) {
        List<ListObjectsContext> contexts = this.getListObjectsContexts(context, prefixes);
        ListObjectsContextHandler elementHandler = new ListObjectsContextHandler();
        ExecutionStatistics stats = this.invoker.invokeThreads(maxThreads, (ElementHandler)elementHandler, contexts);
        long millis = stats.getExecutionTime();
        long count = stats.getIterationCount();
        this.getLog().info((CharSequence)("Acquired listings for " + count + " prefixes.  Time: " + this.formatter.getTime(millis)));
        return elementHandler.getObjectListings();
    }

    protected List<UpdateDirectoryContext> getUpdateDirContexts(List<S3PrefixContext> contexts) {
        ArrayList<UpdateDirectoryContext> list = new ArrayList<UpdateDirectoryContext>();
        for (S3PrefixContext context : contexts) {
            if (context.isRoot()) {
                UpdateDirectoryContext udc = new UpdateDirectoryContext();
                udc.setContext(context);
                list.add(udc);
                continue;
            }
            String delimiter = context.getBucketContext().getDelimiter();
            String trimmedPrefix = this.converter.getTrimmedPrefix(context.getPrefix(), delimiter);
            UpdateDirectoryContext udc1 = new UpdateDirectoryContext();
            udc1.setContext(context);
            udc1.setCopyIfExists(this.isCopyDefaultObjectWithDelimiter());
            udc1.setCopyToKey(context.getPrefix());
            UpdateDirectoryContext udc2 = new UpdateDirectoryContext();
            udc2.setContext(context);
            udc2.setCopyIfExists(this.isCopyDefaultObjectWithoutDelimiter());
            udc2.setCopyToKey(trimmedPrefix);
            list.add(udc1);
            list.add(udc2);
        }
        return list;
    }

    protected List<String> getPathsToRoot(String delimiter, String startingPrefix) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(delimiter);
        String[] prefixes = StringUtils.splitByWholeSeparator((String)startingPrefix, (String)delimiter);
        String newPrefix = "";
        for (int i = 0; i < prefixes.length - 2; ++i) {
            newPrefix = newPrefix + prefixes[i] + delimiter;
            list.add(newPrefix);
        }
        return list;
    }

    protected String getDefaultPrefix(MavenProject project, String orgGroupId) {
        List orgPoms = this.builder.getMavenProjects(this.orgPomGavs);
        DefaultSiteContext context = new DefaultSiteContext();
        context.setLatest(this.latest);
        context.setLatestToken(this.latestToken);
        context.setOrganizationGroupId(orgGroupId);
        context.setOrgPoms(orgPoms);
        return this.builder.getSitePath(project, (SiteContext)context);
    }

    protected void updatePrefix() {
        String s = this.getPrefix();
        if (StringUtils.isEmpty((String)s)) {
            s = this.getDefaultPrefix(this.getProject(), this.getOrganizationGroupId());
        }
        if (!s.endsWith(this.getDelimiter())) {
            s = s + this.getDelimiter();
        }
        this.setPrefix(s);
    }

    protected void updateMojoState() throws MojoExecutionException {
        this.updateCredentials();
        this.validateCredentials();
        this.updatePrefix();
    }

    protected S3BucketContext getS3BucketContext() throws MojoExecutionException {
        AWSCredentials credentials = this.getCredentials();
        AmazonS3Client client = new AmazonS3Client(credentials);
        S3BucketContext context = new S3BucketContext();
        try {
            BeanUtils.copyProperties((Object)context, (Object)((Object)this));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying properties", e);
        }
        context.setClient(client);
        context.setLastModifiedDateFormatter(this.getLastModifiedDateFormatter());
        context.setAbout(this.getAbout());
        return context;
    }

    protected PutObjectRequest getPutIndexObjectRequest(String html, String key) {
        ByteArrayInputStream in = new ByteArrayInputStream(html.getBytes());
        ObjectMetadata om = new ObjectMetadata();
        om.setCacheControl(this.getCacheControl());
        String contentType = S3_INDEX_CONTENT_TYPE;
        om.setContentType(contentType);
        om.setContentLength((long)html.length());
        om.addUserMetadata(S3_INDEX_METADATA_KEY, "true");
        PutObjectRequest request = new PutObjectRequest(this.getBucket(), key, (InputStream)in, om);
        request.setCannedAcl(this.getAcl());
        return request;
    }

    protected SimpleDateFormat getLastModifiedDateFormatter() {
        SimpleDateFormat sdf = new SimpleDateFormat(this.getDateFormat());
        sdf.setTimeZone(TimeZone.getTimeZone(this.getTimezone()));
        return sdf;
    }

    protected boolean isEmpty(Collection<?> c) {
        return c == null || c.size() == 0;
    }

    protected String getAbout() {
        String date = this.getLastModifiedDateFormatter().format(new Date());
        PluginDescriptor descriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
        if (descriptor == null) {
            return "Listing generated by the maven-cloudfront-plugin on " + date;
        }
        String name = descriptor.getArtifactId();
        String version = descriptor.getVersion();
        return "Listing generated by the " + name + " v" + version + " on " + date;
    }

    public void updateDirectory(UpdateDirectoryContext context) throws IOException {
        this.updateDirectory(context.getContext(), context.isCopyIfExists(), context.getCopyToKey());
    }

    protected void updateDirectory(S3PrefixContext context, boolean isCopyIfExists, String copyToKey) throws IOException {
        S3BucketContext bucketContext = context.getBucketContext();
        AmazonS3Client client = context.getBucketContext().getClient();
        String bucket = bucketContext.getBucket();
        boolean containsDefaultObject = this.isExistingObject(context.getObjectListing(), context.getDefaultObjectKey());
        if (containsDefaultObject && isCopyIfExists) {
            String sourceKey = context.getDefaultObjectKey();
            String destKey = copyToKey;
            CopyObjectRequest request = this.getCopyObjectRequest(bucket, sourceKey, destKey);
            this.getLog().debug((CharSequence)("Copy: " + sourceKey + " to " + destKey));
            client.copyObject(request);
        } else {
            PutObjectRequest request = this.getPutIndexObjectRequest(context.getHtml(), copyToKey);
            this.getLog().debug((CharSequence)("Put: " + copyToKey));
            client.putObject(request);
        }
    }

    protected void updateDirectory(S3PrefixContext context) throws IOException {
        String trimmedPrefix = this.converter.getTrimmedPrefix(context.getPrefix(), context.getBucketContext().getDelimiter());
        this.updateDirectory(context, this.isCopyDefaultObjectWithDelimiter(), context.getPrefix());
        this.updateDirectory(context, this.isCopyDefaultObjectWithoutDelimiter(), trimmedPrefix);
    }

    public void updateRoot(UpdateDirectoryContext udc) throws IOException {
        this.updateRoot(udc.getContext());
    }

    protected void updateRoot(S3PrefixContext context) throws IOException {
        AmazonS3Client client = context.getBucketContext().getClient();
        PutObjectRequest request1 = this.getPutIndexObjectRequest(context.getHtml(), context.getBrowseHtmlKey());
        StringBuilder sb = new StringBuilder();
        sb.append(context.getBrowseHtmlKey());
        client.putObject(request1);
        boolean isCreateOrUpdateDefaultObject = this.isCreateOrUpdateDefaultObject(context);
        if (!isCreateOrUpdateDefaultObject) {
            this.getLog().info((CharSequence)("Put: " + sb.toString()));
            return;
        }
        PutObjectRequest request2 = this.getPutIndexObjectRequest(context.getHtml(), context.getDefaultObjectKey());
        this.getLog().info((CharSequence)("Put: " + sb.toString() + ", " + context.getDefaultObjectKey()));
        client.putObject(request2);
    }

    protected List<S3PrefixContext> getS3PrefixContexts(S3BucketContext context, List<ObjectListing> listings) {
        ArrayList<S3PrefixContext> contexts = new ArrayList<S3PrefixContext>();
        for (ObjectListing listing : listings) {
            S3PrefixContext prefixContext = this.getS3PrefixContext(context, listing);
            contexts.add(prefixContext);
        }
        return contexts;
    }

    protected S3PrefixContext getS3PrefixContext(S3BucketContext context, ObjectListing objectListing) {
        String prefix = objectListing.getPrefix();
        String delimiter = context.getDelimiter();
        List<String[]> data = this.converter.getData(objectListing, prefix, delimiter);
        String html = this.generator.getHtml(data, prefix, delimiter);
        String defaultObjectKey = StringUtils.isEmpty((String)prefix) ? this.getDefaultObjectKey() : prefix + this.getDefaultObjectKey();
        String browseHtmlKey = StringUtils.isEmpty((String)prefix) ? this.getBrowseKey() : prefix + this.getBrowseKey();
        boolean isRoot = StringUtils.isEmpty((String)prefix);
        S3PrefixContext prefixContext = new S3PrefixContext();
        prefixContext.setObjectListing(objectListing);
        prefixContext.setHtml(html);
        prefixContext.setRoot(isRoot);
        prefixContext.setDefaultObjectKey(defaultObjectKey);
        prefixContext.setPrefix(prefix);
        prefixContext.setBucketContext(context);
        prefixContext.setBrowseHtmlKey(browseHtmlKey);
        return prefixContext;
    }

    protected boolean isExistingObject(ObjectListing objectListing, String key) {
        List summaries = objectListing.getObjectSummaries();
        for (S3ObjectSummary summary : summaries) {
            if (!key.equals(summary.getKey())) continue;
            return true;
        }
        return false;
    }

    protected boolean isCreateOrUpdateDefaultObject(S3PrefixContext context) {
        if (!this.isExistingObject(context.getObjectListing(), context.getDefaultObjectKey())) {
            return true;
        }
        S3BucketContext s3Context = context.getBucketContext();
        S3Object s3Object = s3Context.getClient().getObject(s3Context.getBucket(), context.getDefaultObjectKey());
        boolean isOurDefaultObject = this.isOurObject(s3Object);
        IOUtils.closeQuietly((InputStream)s3Object.getObjectContent());
        return isOurDefaultObject;
    }

    protected boolean isOurObject(S3Object s3Object) {
        ObjectMetadata metadata = s3Object.getObjectMetadata();
        Map userMetadata = metadata.getUserMetadata();
        String value = (String)userMetadata.get(S3_INDEX_METADATA_KEY);
        boolean isOurObject = "true".equals(value);
        return isOurObject;
    }

    protected CopyObjectRequest getCopyObjectRequest(String bucket, String sourceKey, String destKey) {
        CopyObjectRequest request = new CopyObjectRequest(bucket, sourceKey, bucket, destKey);
        request.setCannedAccessControlList(this.getAcl());
        return request;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDefaultObjectKey() {
        return this.defaultObjectKey;
    }

    public void setDefaultObjectKey(String defaultCloudFrontObject) {
        this.defaultObjectKey = defaultCloudFrontObject;
    }

    public String getFileImage() {
        return this.fileImage;
    }

    public void setFileImage(String fileImage) {
        this.fileImage = fileImage;
    }

    public String getDirectoryImage() {
        return this.directoryImage;
    }

    public void setDirectoryImage(String directoryImage) {
        this.directoryImage = directoryImage;
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public boolean isCopyDefaultObjectWithDelimiter() {
        return this.copyDefaultObjectWithDelimiter;
    }

    public void setCopyDefaultObjectWithDelimiter(boolean copyDefaultObjectWithDelimiter) {
        this.copyDefaultObjectWithDelimiter = copyDefaultObjectWithDelimiter;
    }

    public boolean isCopyDefaultObjectWithoutDelimiter() {
        return this.copyDefaultObjectWithoutDelimiter;
    }

    public void setCopyDefaultObjectWithoutDelimiter(boolean copyDefaultObjectWithoutDelimiter) {
        this.copyDefaultObjectWithoutDelimiter = copyDefaultObjectWithoutDelimiter;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public void setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
    }

    public String getBrowseKey() {
        return this.browseKey;
    }

    public void setBrowseKey(String browseHtml) {
        this.browseKey = browseHtml;
    }

    public String getOrganizationGroupId() {
        return this.organizationGroupId;
    }

    public void setOrganizationGroupId(String organizationGroupId) {
        this.organizationGroupId = organizationGroupId;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threadCount) {
        this.threads = threadCount;
    }

    public CannedAccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(CannedAccessControlList acl) {
        this.acl = acl;
    }

    public List<String> getOrgPomGavs() {
        return this.orgPomGavs;
    }

    public void setOrgPomGavs(List<String> orgPomGavs) {
        this.orgPomGavs = orgPomGavs;
    }

    public String getLatestToken() {
        return this.latestToken;
    }

    public void setLatestToken(String latestToken) {
        this.latestToken = latestToken;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public void setLatest(boolean latest) {
        this.latest = latest;
    }
}

