/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.mojo.s3;

import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.kuali.maven.mojo.s3.DisplayRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayRowComparator
implements Comparator<DisplayRow> {
    public static final String DEFAULT_SEPARATORS = ".-";
    public static final String DEFAULT_DELIMITER = "/";
    String separators = ".-";
    String delimiter = "/";

    @Override
    public int compare(DisplayRow one, DisplayRow two) {
        String show1 = one.getShow();
        String show2 = two.getShow();
        if (show1 == null && show2 == null) {
            return 0;
        }
        if (show1 == null) {
            return -1;
        }
        if (show2 == null) {
            return 1;
        }
        show1 = StringUtils.strip((String)show1, (String)this.delimiter);
        show2 = StringUtils.strip((String)show2, (String)this.delimiter);
        String[] tokens1 = StringUtils.split((String)show1, (String)this.separators);
        String[] tokens2 = StringUtils.split((String)show2, (String)this.separators);
        int len = Math.min(tokens1.length, tokens2.length);
        for (int i = 0; i < len; ++i) {
            String token1 = tokens1[i];
            String token2 = tokens2[i];
            int compareTo = this.compareTokens(token1, token2);
            if (compareTo == 0) continue;
            return compareTo;
        }
        if (tokens1.length > tokens2.length) {
            return -1;
        }
        if (tokens1.length < tokens2.length) {
            return 1;
        }
        return 0;
    }

    protected int compareTokens(String token1, String token2) {
        try {
            Double d1 = new Double(token1);
            Double d2 = new Double(token2);
            return d1.compareTo(d2);
        }
        catch (NumberFormatException numberFormatException) {
            return token1.compareTo(token2);
        }
    }

    public String getSeparators() {
        return this.separators;
    }

    public void setSeparators(String separators) {
        this.separators = separators;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

