/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.jenkins.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.kuali.maven.plugins.jenkins.helper.DirectoryFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsyncHelper {
    private static final Logger logger = LoggerFactory.getLogger(RsyncHelper.class);

    public List<File> getMatchingDirs(File dir, String directoryName, DirectoryFileFilter filter) {
        ArrayList<File> fileList = new ArrayList<File>();
        String path = dir.getAbsolutePath();
        System.out.println(path);
        boolean match = path.endsWith(File.separator + directoryName);
        if (!match) {
            File[] dirs;
            for (File newDir : dirs = dir.listFiles(filter)) {
                fileList.addAll(this.getMatchingDirs(newDir, directoryName, filter));
            }
        } else {
            fileList.add(dir);
        }
        return fileList;
    }

    public List<File> getWorkspaceDirs(File basedir) {
        File[] dirs;
        ArrayList<File> dirList = new ArrayList<File>();
        for (File dir : dirs = basedir.listFiles(new DirectoryFileFilter())) {
            File[] subdirs;
            for (File subdir : subdirs = dir.listFiles(new DirectoryFileFilter())) {
                String path = subdir.getAbsolutePath();
                if (!path.endsWith("workspace")) continue;
                dirList.add(subdir);
            }
        }
        return dirList;
    }

    public List<String> getExcludesList(File basedir, List<File> excludeDirs) {
        String basedirPath = basedir.getAbsolutePath();
        ArrayList<String> excludes = new ArrayList<String>();
        for (File excludeDir : excludeDirs) {
            String path = excludeDir.getAbsolutePath();
            logger.debug("path=" + path);
            if (excludeDir.equals(basedir)) continue;
            logger.debug("basedirPath=" + basedirPath);
            String token = path.substring(basedirPath.length() + 1);
            excludes.add(token);
        }
        return excludes;
    }
}

