/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.jenkins.helper;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.maven.plugins.jenkins.context.ProcessContext;
import org.kuali.maven.plugins.jenkins.context.ProcessException;
import org.kuali.maven.plugins.jenkins.context.ProcessResult;
import org.kuali.maven.plugins.jenkins.helper.Helper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessHelper {
    private static final Logger logger = LoggerFactory.getLogger(ProcessHelper.class);

    public ProcessResult execute(String executable) {
        return this.execute(executable, (String[])null);
    }

    public ProcessResult execute(String executable, String ... args) {
        return this.execute(executable, args, (String)null);
    }

    public ProcessResult execute(String executable, String[] args, String input) {
        ProcessContext context = new ProcessContext();
        context.setExecutable(executable);
        context.setArgs(args);
        context.setInput(input);
        return this.execute(context);
    }

    public ProcessResult execute(ProcessContext context) {
        try {
            String[] command = this.getProcessBuilderCommand(context.getExecutable(), context.getArgs());
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            long start = System.currentTimeMillis();
            logger.debug("Starting process");
            Process process = builder.start();
            logger.debug("Process started");
            if (!StringUtils.isBlank((String)context.getInput())) {
                logger.debug("Writing input=" + context.getInput());
                IOUtils.write((String)context.getInput(), (OutputStream)process.getOutputStream());
                logger.debug("Done writing input");
                process.getOutputStream().close();
            }
            logger.debug("Reading output");
            String output = IOUtils.toString((InputStream)process.getInputStream());
            logger.debug("Done reading output=" + output);
            List<String> outputLines = Helper.getLines(output);
            int exitValue = process.waitFor();
            long stop = System.currentTimeMillis();
            long elapsed = stop - start;
            ProcessResult result = new ProcessResult();
            result.setContext(context);
            result.setExitValue(exitValue);
            result.setOutput(output);
            result.setOutputLines(outputLines);
            result.setStart(start);
            result.setStop(stop);
            result.setElapsed(elapsed);
            return result;
        }
        catch (Exception e) {
            throw new ProcessException(e);
        }
    }

    protected String[] getProcessBuilderCommand(String executable, String ... args) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(executable);
        Helper.addToList(command, args);
        return Helper.toArray(command);
    }
}

