/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.jenkins.helper;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.kuali.maven.common.Extractor;
import org.kuali.maven.common.PropertiesUtils;
import org.kuali.maven.common.ResourceUtils;
import org.kuali.maven.plugins.jenkins.BaseMojo;
import org.kuali.maven.plugins.jenkins.CliMojo;
import org.kuali.maven.plugins.jenkins.Command;
import org.kuali.maven.plugins.jenkins.DeleteJobMojo;
import org.kuali.maven.plugins.jenkins.DeleteJobsMojo;
import org.kuali.maven.plugins.jenkins.GenJobMojo;
import org.kuali.maven.plugins.jenkins.GenJobsMojo;
import org.kuali.maven.plugins.jenkins.GetJobMojo;
import org.kuali.maven.plugins.jenkins.GetJobsMojo;
import org.kuali.maven.plugins.jenkins.PushJobsMojo;
import org.kuali.maven.plugins.jenkins.RunJobCommand;
import org.kuali.maven.plugins.jenkins.RunJobMojo;
import org.kuali.maven.plugins.jenkins.RunJobsMojo;
import org.kuali.maven.plugins.jenkins.SimpleJobCommand;
import org.kuali.maven.plugins.jenkins.Style;
import org.kuali.maven.plugins.jenkins.context.GAV;
import org.kuali.maven.plugins.jenkins.context.JenkinsException;
import org.kuali.maven.plugins.jenkins.context.ProcessContext;
import org.kuali.maven.plugins.jenkins.context.ProcessResult;
import org.kuali.maven.plugins.jenkins.helper.CommandHelper;
import org.kuali.maven.plugins.jenkins.helper.Counter;
import org.kuali.maven.plugins.jenkins.helper.Helper;
import org.kuali.maven.plugins.jenkins.helper.JavaHelper;
import org.kuali.maven.plugins.jenkins.helper.SshHelper;
import org.kuali.maven.plugins.jenkins.helper.XmlFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsHelper {
    private final Logger logger = LoggerFactory.getLogger(JenkinsHelper.class);
    public static final String XML_EXTENSION = ".xml";
    public static final int SUCCESS_CODE = 0;
    public static final int NO_SUCH_COMMAND = 255;
    public static final String SERVER_ARG = "-s";
    public static final String NONE = "NONE";
    public static final String DASH = "-";
    public static final String FS = System.getProperty("file.separator", "/");
    Extractor extractor = new Extractor();
    PropertiesUtils propertiesUtils = new PropertiesUtils();
    ResourceUtils resourceUtils = new ResourceUtils();
    JavaHelper javaHelper = new JavaHelper();
    SshHelper sshHelper = new SshHelper();
    CommandHelper cmdHelper = new CommandHelper();

    protected List<String> getNamesList(String csvNames, List<String> names) {
        if (!Helper.isEmpty(names)) {
            return names;
        }
        return Helper.splitAndTrimCSVToList(csvNames);
    }

    protected List<String> getJobNames(BaseMojo mojo, String csvNames, List<String> names) {
        List<String> namesList = this.getNamesList(csvNames, names);
        ArrayList<String> newNames = new ArrayList<String>();
        for (String name : namesList) {
            String newName = this.getJobName(mojo, name);
            newNames.add(newName);
        }
        return newNames;
    }

    public void execute(GetJobMojo mojo) {
        List<String> jobNames = this.getJobNames(mojo, mojo.getName(), null);
        List<Command> commands = this.createGetJobCommands(mojo, mojo.getCmd(), jobNames);
        this.executeCli((BaseMojo)mojo, commands);
    }

    public void execute(GetJobsMojo mojo) {
        List<String> jobNames = this.getJobNames(mojo, mojo.getNames(), mojo.getNameList());
        List<Command> commands = this.createGetJobCommands(mojo, mojo.getCmd(), jobNames);
        this.executeCli((BaseMojo)mojo, commands);
    }

    protected List<Command> createGetJobCommands(BaseMojo mojo, String cmd, List<String> jobNames) {
        ArrayList<Command> commands = new ArrayList<Command>();
        for (String jobName : jobNames) {
            Command command = this.createGetJobCommand(mojo, cmd, jobName);
            commands.add(command);
        }
        return commands;
    }

    protected Command createGetJobCommand(BaseMojo mojo, String cmd, String jobName) {
        String filename = mojo.getWorkingDir() + FS + jobName + XML_EXTENSION;
        String[] args = new String[]{cmd, jobName};
        Command command = new Command();
        command.setArgs(Arrays.asList(args));
        command.setStdout(new File(filename));
        return command;
    }

    protected GAV getGav(Properties properties) {
        String groupId = properties.getProperty("jenkins.cli.groupId");
        String artifactId = properties.getProperty("jenkins.cli.artifactId");
        String version = properties.getProperty("jenkins.cli.version");
        if (Helper.anyAreBlank(groupId, artifactId, version)) {
            return null;
        }
        GAV gav = new GAV();
        gav.setVersion(version);
        gav.setArtifactId(artifactId);
        gav.setGroupId(groupId);
        return gav;
    }

    protected GAV getGav(Artifact artifact) {
        GAV gav = new GAV();
        gav.setGroupId(artifact.getGroupId());
        gav.setArtifactId(artifact.getArtifactId());
        gav.setVersion(artifact.getVersion());
        return gav;
    }

    protected GAV getGav(MavenProject project) {
        try {
            String location = "classpath:org/kuali/maven/plugins/jenkins/jenkins-cli.properties";
            Properties internal = this.propertiesUtils.getProperties(location);
            GAV internalGAV = this.getGav(internal);
            GAV overrideGAV = this.getGav(project.getProperties());
            GAV gav = internalGAV;
            if (overrideGAV != null && !internalGAV.equals(overrideGAV)) {
                this.logger.info("Jenkins CLI override: [internal=" + internalGAV + ", override=" + overrideGAV + "]");
                gav = overrideGAV;
            }
            return gav;
        }
        catch (IOException e) {
            throw new JenkinsException(e);
        }
    }

    protected File getJenkinsJar(MavenProject project, List<Artifact> pluginArtifacts) {
        GAV gav = this.getGav(project);
        File jar = this.getJar(gav, pluginArtifacts);
        if (jar == null) {
            throw new JenkinsException("Unable to locate jenkins-cli.jar");
        }
        return jar;
    }

    protected File getJar(GAV gav, List<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!this.equals(artifact, gav)) continue;
            return artifact.getFile();
        }
        return null;
    }

    protected boolean equals(Artifact artifact, GAV gav) {
        GAV artifactGav = this.getGav(artifact);
        return artifactGav.equals(gav);
    }

    protected List<File> getFiles(File workingDir) {
        if (!workingDir.exists()) {
            return new ArrayList<File>();
        }
        XmlFileFilter filter = new XmlFileFilter();
        File[] files = workingDir.listFiles(filter);
        return Arrays.asList(files);
    }

    protected void pushJobs(BaseMojo mojo, String cmd) {
        try {
            List<Command> commands = this.getCommands(mojo.getWorkingDir(), cmd);
            this.executeCli(mojo, commands);
        }
        catch (IOException e) {
            throw new JenkinsException(e);
        }
    }

    protected List<Command> getCommands(File workingDir, String cmd) throws IOException {
        List<File> files = this.getFiles(workingDir);
        ArrayList<Command> commands = new ArrayList<Command>();
        for (File file : files) {
            Command command = this.getCommand(file, cmd);
            commands.add(command);
        }
        return commands;
    }

    protected String getJobName(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(XML_EXTENSION);
        return name.substring(0, pos);
    }

    protected Command getCommand(File file, String cmd) throws IOException {
        String stdin = this.resourceUtils.read(file.getAbsolutePath());
        String jobName = this.getJobName(file);
        String[] args = new String[]{cmd, jobName};
        Command command = new Command();
        command.setStdin(stdin);
        command.setArgs(Arrays.asList(args));
        return command;
    }

    protected String getInput(Command cmd) {
        if (!StringUtils.isBlank((String)cmd.getStdinUrl())) {
            try {
                return this.resourceUtils.read(cmd.getStdinUrl());
            }
            catch (IOException e) {
                throw new JenkinsException(e);
            }
        }
        return cmd.getStdin();
    }

    protected Map<String, String> getSshOptions(int port, boolean verbose) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (verbose) {
            options.put("v", "");
        }
        options.put("p", port + "");
        return options;
    }

    protected String[] getCliArgs(String url, List<String> args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(SERVER_ARG);
        list.add(url);
        list.addAll(args);
        return Helper.toArray(list);
    }

    protected int[] getSuccessCodes(BaseMojo mojo) {
        String csv = mojo.getSuccessCodes();
        return Helper.toIntArray(csv);
    }

    protected void handleResult(Command command, ProcessResult result, BaseMojo mojo) {
        int[] successCodes = this.getSuccessCodes(mojo);
        int exitValue = result.getExitValue();
        if (Helper.isMatch(exitValue, successCodes)) {
            this.handleSuccess(mojo, command, result);
        } else {
            this.handleFailure(mojo, result);
        }
    }

    protected void logInfo(List<String> lines) {
        if (lines.size() == 0) {
            return;
        }
        for (String line : lines) {
            this.logger.info(line);
        }
    }

    protected void logError(List<String> lines) {
        String top = this.getTop(lines);
        if (top != null) {
            this.logger.error(top);
        }
    }

    protected void logWarning(List<String> lines) {
        String top = this.getTop(lines);
        if (top != null) {
            this.logger.warn(top);
        }
    }

    protected String getTop(List<String> lines) {
        for (String line : lines) {
            if (StringUtils.isBlank((String)line)) continue;
            return line;
        }
        return null;
    }

    protected void handleFailure(BaseMojo mojo, ProcessResult result) {
        if (mojo.isStopOnError()) {
            this.logger.error("Jenkins CLI Exception:" + this.getErrorMessage(mojo, result));
            throw new JenkinsException("Jenkins CLI Exception");
        }
        if (mojo.isFailOnError()) {
            this.logError(result.getOutputLines());
        } else {
            this.logWarning(result.getOutputLines());
        }
    }

    protected void handleSuccess(BaseMojo mojo, Command command, ProcessResult result) {
        File stdout = command.getStdout();
        if (stdout != null) {
            this.write(stdout.getAbsolutePath(), result.getOutput());
        } else {
            List<String> lines = result.getOutputLines();
            if (result.getExitValue() == 0) {
                this.logInfo(lines);
            } else {
                String top = this.getTop(lines);
                if (top != null) {
                    this.logger.info(top);
                }
            }
        }
    }

    protected void write(String filename, String content) {
        try {
            this.resourceUtils.write(new File(filename), content);
        }
        catch (IOException e) {
            throw new JenkinsException(e);
        }
    }

    protected Map<String, String> getBuildParameters(Map<String, String> map, String csv) {
        HashMap<String, String> buildParameters = new HashMap<String, String>();
        if (!Helper.isEmpty(map)) {
            buildParameters.putAll(map);
        }
        if (!StringUtils.isBlank((String)csv)) {
            String[] keyValuePairs = Helper.splitAndTrimCSV(csv);
            Map<String, String> csvMap = Helper.toMap(keyValuePairs);
            buildParameters.putAll(csvMap);
        }
        return buildParameters;
    }

    protected RunJobCommand getRunJobCommand(RunJobMojo mojo, String jobName, Map<String, String> params) {
        RunJobCommand rjc = new RunJobCommand();
        rjc.setName(jobName);
        rjc.setParams(params);
        rjc.setCommand(mojo.getCmd());
        rjc.setWait(mojo.isWait());
        rjc.setSkipIfNoChanges(mojo.isSkipIfNoChanges());
        return rjc;
    }

    public void updateMojo(BaseMojo mojo) {
        MavenProject project = mojo.getProject();
        String scmType = this.extractor.getScmType(project.getScm());
        String scmUrl = this.extractor.getScmUrl(project.getScm());
        String majorVersion = this.extractor.getMajorVersion(project.getVersion());
        if (StringUtils.isBlank((String)mojo.getScmType())) {
            mojo.setScmType(scmType);
        }
        if (StringUtils.isBlank((String)mojo.getScmUrl())) {
            mojo.setScmUrl(scmUrl);
        }
        if (StringUtils.isBlank((String)mojo.getMajorVersion())) {
            mojo.setMajorVersion(majorVersion);
        }
    }

    public void execute(DeleteJobMojo mojo) {
        String ignoreCodes = mojo.getIgnoreCodes();
        String successCodes = mojo.getSuccessCodes();
        String newSuccessCodes = successCodes + "," + ignoreCodes;
        mojo.setSuccessCodes(newSuccessCodes);
        String jobName = this.getJobName(mojo, mojo.getName());
        SimpleJobCommand sjc = this.getSimpleJobCommand(jobName, mojo.getCmd());
        Command command = new Command();
        command.setArgs(this.cmdHelper.toArgs(sjc));
        this.executeCli((BaseMojo)mojo, command);
    }

    protected List<SimpleJobCommand> getSimpleJobCommands(List<String> names, String cmd) {
        ArrayList<SimpleJobCommand> commands = new ArrayList<SimpleJobCommand>();
        for (String name : names) {
            SimpleJobCommand sjc = this.getSimpleJobCommand(name, cmd);
            commands.add(sjc);
        }
        return commands;
    }

    protected SimpleJobCommand getSimpleJobCommand(String name, String cmd) {
        SimpleJobCommand sjc = new SimpleJobCommand();
        sjc.setName(name);
        sjc.setCommand(cmd);
        return sjc;
    }

    public void execute(DeleteJobsMojo mojo) {
        String ignoreCodes = mojo.getIgnoreCodes();
        String successCodes = mojo.getSuccessCodes();
        String newSuccessCodes = successCodes + "," + ignoreCodes;
        mojo.setSuccessCodes(newSuccessCodes);
        List<String> jobNames = this.getJobNames(mojo, mojo.getNames(), mojo.getNameList());
        List<SimpleJobCommand> sjcs = this.getSimpleJobCommands(jobNames, mojo.getCmd());
        List<Command> commands = this.getCommandsFromSimple(sjcs);
        this.executeCli((BaseMojo)mojo, commands);
    }

    public void execute(RunJobMojo mojo) {
        String jobName = this.getJobName(mojo, mojo.getName());
        Map<String, String> params = this.getBuildParameters(mojo.getParamMap(), mojo.getParams());
        RunJobCommand rjc = this.getRunJobCommand(mojo, jobName, params);
        Command command = new Command();
        command.setArgs(this.cmdHelper.toArgs(rjc));
        this.executeCli((BaseMojo)mojo, command);
    }

    protected void updateCommands(List<RunJobCommand> commands, String cmd, BaseMojo mojo) {
        for (RunJobCommand command : commands) {
            String name = this.getJobName(mojo, command.getName());
            command.setName(name);
            command.setCommand(cmd);
        }
    }

    protected List<Command> getCommandsFromSimple(List<SimpleJobCommand> sjcs) {
        ArrayList<Command> commands = new ArrayList<Command>();
        for (SimpleJobCommand sjc : sjcs) {
            Command command = new Command();
            command.setArgs(this.cmdHelper.toArgs(sjc));
            commands.add(command);
        }
        return commands;
    }

    protected List<Command> getCommands(List<RunJobCommand> rjcs) {
        ArrayList<Command> commands = new ArrayList<Command>();
        for (RunJobCommand rjc : rjcs) {
            Command command = new Command();
            command.setArgs(this.cmdHelper.toArgs(rjc));
            commands.add(command);
        }
        return commands;
    }

    public void execute(RunJobsMojo mojo) {
        if (Helper.isEmpty(mojo.getCommands())) {
            return;
        }
        this.updateCommands(mojo.getCommands(), mojo.getCmd(), mojo);
        List<Command> commands = this.getCommands(mojo.getCommands());
        this.executeCli((BaseMojo)mojo, commands);
    }

    public void execute(PushJobsMojo mojo) {
        this.pushJobs(mojo, mojo.getCmd());
    }

    public void execute(CliMojo mojo) {
        List<Command> cmds = this.cmdHelper.getCommands(mojo);
        this.executeCli((BaseMojo)mojo, cmds);
    }

    protected void executeCli(BaseMojo mojo, Command command) {
        this.executeCli(mojo, Helper.toList(command));
    }

    protected String getActualUrl(BaseMojo mojo) {
        if (mojo.isSshEnabled()) {
            return mojo.getUsername() + "@" + mojo.getHostname();
        }
        return mojo.getUrl();
    }

    protected void executeCli(BaseMojo mojo, List<Command> commands) {
        String url = this.getActualUrl(mojo);
        this.logger.info("Jenkins URL - " + url);
        File jar = null;
        if (!mojo.isSshEnabled()) {
            jar = this.getJenkinsJar(mojo.getProject(), mojo.getPluginArtifacts());
            this.logger.info("Jenkins CLI: " + jar.getPath());
        }
        ArrayList<ProcessResult> results = new ArrayList<ProcessResult>();
        for (Command command : commands) {
            this.logger.info(Helper.toString(command.getArgs()));
            ProcessResult result = this.executeCli(mojo, jar, url, command);
            this.handleResult(command, result, mojo);
            results.add(result);
        }
        this.handleResults(results, mojo);
    }

    protected ProcessResult executeCli(BaseMojo mojo, File jar, String url, Command cmd) {
        String input = this.getInput(cmd);
        return this.executeCli(mojo, jar, url, cmd.getArgs(), input);
    }

    protected ProcessResult executeCli(BaseMojo mojo, File jar, String url, List<String> args, String input) {
        if (mojo.isSshEnabled()) {
            ArrayList<String> cliArgs = new ArrayList<String>();
            cliArgs.add(url);
            cliArgs.addAll(args);
            Map<String, String> options = this.getSshOptions(mojo.getSshPort(), mojo.isSshVerbose());
            return this.sshHelper.execute(options, cliArgs, input);
        }
        String[] cliArgs = this.getCliArgs(url, args);
        return this.javaHelper.executeJar(jar, cliArgs, input);
    }

    protected void handleResults(List<ProcessResult> results, BaseMojo mojo) {
        int[] successCodes = this.getSuccessCodes(mojo);
        ArrayList<ProcessResult> errors = new ArrayList<ProcessResult>();
        for (ProcessResult result : results) {
            int exitValue = result.getExitValue();
            if (Helper.isMatch(exitValue, successCodes)) continue;
            errors.add(result);
        }
        if (errors.size() == 0) {
            return;
        }
        if (mojo.isFailOnError()) {
            this.logger.error(this.getErrorMessage(mojo, errors));
            throw new JenkinsException("Jenkins CLI error");
        }
        this.logger.warn(this.getWarnMessage(errors));
    }

    protected String getWarnMessage(List<ProcessResult> errors) {
        StringBuilder sb = new StringBuilder();
        if (errors.size() == 1) {
            sb.append("There was 1 error.");
        } else {
            sb.append("There were " + errors.size() + " errors.");
        }
        return sb.toString();
    }

    protected String getErrorMessage(BaseMojo mojo, List<ProcessResult> errors) {
        StringBuilder sb = new StringBuilder();
        if (errors.size() == 1) {
            sb.append("There was 1 error.");
        } else {
            sb.append("There were " + errors.size() + " errors.");
        }
        for (ProcessResult result : errors) {
            sb.append(this.getErrorMessage(mojo, result));
        }
        return sb.toString();
    }

    protected String getErrorMessage(BaseMojo mojo, ProcessResult result) {
        ProcessContext context = result.getContext();
        int exitValue = result.getExitValue();
        String top = this.getTop(result.getOutputLines());
        String[] args = result.getContext().getArgs();
        String cmd = Helper.toString(args, " ");
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("msg: " + top + "\n");
        sb.append("executable: " + context.getExecutable() + "\n");
        sb.append("cmd: " + cmd + "\n");
        sb.append("result: " + exitValue + "\n");
        sb.append("input: " + this.getInputErrorMessage(mojo, context.getInput()) + "\n");
        sb.append("details: " + result.getOutput());
        return sb.toString();
    }

    protected String getInputErrorMessage(BaseMojo mojo, String input) {
        String s = Helper.toEmpty(input);
        if (StringUtils.isBlank((String)s)) {
            return s;
        }
        int length = input.length();
        if (length > 50) {
            long count = Counter.increment() + 1L;
            File dir = mojo.getWorkingDir();
            String filename = dir + FS + "error" + FS + "input-" + count + ".log";
            File file = new File(filename);
            this.write(filename, input);
            return Helper.getRelativePath(mojo.getProject().getBasedir(), file);
        }
        return input;
    }

    public void execute(GenJobsMojo mojo) {
        List<String> types = Helper.splitAndTrimCSVToList(mojo.getTypes());
        this.generateJobs(mojo, types);
    }

    public void execute(GenJobMojo mojo) {
        this.generateJob(mojo, mojo.getType());
    }

    protected void generateJobs(BaseMojo mojo, List<String> types) {
        for (String type : types) {
            this.generateJob(mojo, type);
        }
    }

    protected String getRelativePath(BaseMojo mojo, String filename) {
        File file;
        File dir = mojo.getProject().getBasedir();
        String relativePath = Helper.getRelativePath(dir, file = new File(filename));
        if (relativePath == null) {
            return filename;
        }
        return relativePath;
    }

    protected List<Style> getDefaultStyles() {
        ArrayList<Style> styles = new ArrayList<Style>();
        Style freestyle = new Style();
        freestyle.setName("freestyle");
        freestyle.setTemplate("classpath:org/kuali/jenkins/jobs/freestyle.xml");
        Style maven = new Style();
        maven.setName("maven");
        maven.setTemplate("classpath:org/kuali/jenkins/jobs/maven.xml");
        styles.add(freestyle);
        styles.add(maven);
        return styles;
    }

    protected String getTemplate(List<Style> styles, String style) {
        if (styles == null) {
            styles = this.getDefaultStyles();
        } else {
            styles.addAll(this.getDefaultStyles());
        }
        for (Style element : styles) {
            if (!element.getName().equals(style)) continue;
            return element.getTemplate();
        }
        throw new IllegalArgumentException("'" + style + "' is unknown.");
    }

    protected void generateJob(BaseMojo mojo, String type) {
        try {
            String jobName = this.getJobName(mojo, type);
            String filename = mojo.getWorkingDir() + FS + jobName + XML_EXTENSION;
            String relativePath = this.getRelativePath(mojo, filename);
            mojo.getLog().info((CharSequence)("Generating: " + relativePath));
            Properties properties = this.getProperties(mojo, type, mojo.getTimestampFormat());
            String template = this.getTemplate(mojo.getStyles(), mojo.getStyle());
            String xml = this.resourceUtils.read(template);
            String resolvedXml = this.propertiesUtils.getResolvedValue(xml, properties);
            File file = new File(filename);
            this.resourceUtils.write(file, resolvedXml);
        }
        catch (IOException e) {
            throw new JenkinsException(e);
        }
    }

    protected void showProperties(Properties properties) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("jenkins.job.builders");
        keys.add("jenkins.job.builders.shell");
        keys.add("jenkins.job.builders.shell.command");
        keys.add("jenkins.job.builders.shell.command.release");
        for (String key : keys) {
            this.logger.info(key + "=" + properties.getProperty(key));
        }
    }

    protected boolean isKnownJobType(BaseMojo mojo, String name) {
        String jobTypes = mojo.getJobTypes();
        if (StringUtils.isBlank((String)jobTypes)) {
            return false;
        }
        if (NONE.equalsIgnoreCase(jobTypes)) {
            return false;
        }
        List<String> jobTypesList = Helper.splitAndTrimCSVToList(mojo.getJobTypes());
        return jobTypesList.contains(name);
    }

    protected String getJobName(BaseMojo mojo, String name) {
        if (this.isKnownJobType(mojo, name)) {
            StringBuilder sb = new StringBuilder();
            sb.append(mojo.getProject().getArtifactId());
            sb.append(DASH);
            if (!mojo.isExcludeVersion()) {
                sb.append(mojo.getMajorVersion());
                sb.append(DASH);
            }
            sb.append(name);
            return sb.toString();
        }
        return name;
    }

    protected Properties getProperties(BaseMojo mojo, String type, String timestampFormat) throws IOException {
        List<String> locations = this.getLocations(mojo, type);
        Properties resourceProperties = this.propertiesUtils.getProperties(locations);
        Properties jenkinsProperties = this.getJenkinsProperties(mojo, timestampFormat);
        Properties projectProperties = mojo.getProject().getProperties();
        Properties environmentProperties = this.propertiesUtils.getEnvironmentProperties();
        Properties systemProperties = System.getProperties();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)resourceProperties);
        properties.putAll((Map<?, ?>)jenkinsProperties);
        properties.putAll((Map<?, ?>)projectProperties);
        properties.putAll((Map<?, ?>)environmentProperties);
        properties.putAll((Map<?, ?>)systemProperties);
        return properties;
    }

    protected Properties getJenkinsProperties(BaseMojo mojo, String timestampFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(timestampFormat);
        Date now = new Date(System.currentTimeMillis());
        MavenProject project = mojo.getProject();
        Properties properties = new Properties();
        properties.setProperty("jenkins.project.scmType", mojo.getScmType());
        properties.setProperty("jenkins.project.scmUrl", mojo.getScmUrl());
        properties.setProperty("jenkins.project.majorVersion", mojo.getMajorVersion());
        properties.setProperty("jenkins.project.groupId", project.getGroupId());
        properties.setProperty("jenkins.project.artifactId", project.getArtifactId());
        properties.setProperty("jenkins.build.timestamp", sdf.format(now));
        return properties;
    }

    protected List<String> getLocations(BaseMojo mojo, String type) {
        ArrayList<String> locations = new ArrayList<String>();
        locations.add("classpath:org/kuali/jenkins/jobs/properties/common.xml");
        locations.add("classpath:org/kuali/jenkins/jobs/properties/" + mojo.getScmType() + XML_EXTENSION);
        locations.add("classpath:org/kuali/jenkins/jobs/properties/types/" + type + XML_EXTENSION);
        return locations;
    }
}

