/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.jenkins.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.maven.plugins.jenkins.context.ProcessResult;
import org.kuali.maven.plugins.jenkins.helper.ExecutableHelper;
import org.kuali.maven.plugins.jenkins.helper.Helper;

public class JavaHelper
extends ExecutableHelper {
    public static final String FS = System.getProperty("file.separator");
    public static final String JAVA_HOME_KEY = "java.home";
    public static final String BIN = "bin";
    public static final String JAVA = "java";
    public static final String[] EXECUTABLES = new String[]{"java", "javaw"};
    public static final String[] EXTENSIONS = new String[]{"", ".exe"};
    public static final String EXECUTE_JAR_ARG = "-jar";

    public ProcessResult executeJar(File jar, String ... args) {
        return this.executeJar(jar, args, (String)null);
    }

    public ProcessResult executeJar(File jar, String[] args, String input) {
        String executable = this.getExecutable();
        String[] jarArgs = this.getExecuteJarArgs(jar, args);
        return this.helper.execute(executable, jarArgs, input);
    }

    @Override
    public String getExecutable() {
        return this.getExecutable(EXECUTABLES, EXTENSIONS);
    }

    public String getExecutable(String[] executables, String[] extensions) {
        List<String> paths = this.getPotentialPaths(executables, extensions);
        for (String path : paths) {
            if (!this.isUsable(path)) continue;
            return path;
        }
        return JAVA;
    }

    protected String[] getExecuteJarArgs(File jar, String ... args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(EXECUTE_JAR_ARG);
        list.add(jar.getAbsolutePath());
        Helper.addToList(list, args);
        return list.toArray(new String[list.size()]);
    }

    protected boolean isUsable(String path) {
        File file = new File(path);
        return file.exists() && file.canExecute();
    }

    protected List<String> getPotentialPaths(String[] executables, String[] extensions) {
        String javaHome = System.getProperty(JAVA_HOME_KEY);
        if (StringUtils.isBlank((String)javaHome)) {
            return new ArrayList<String>();
        }
        if (!javaHome.endsWith(FS)) {
            javaHome = javaHome + FS;
        }
        String dir = javaHome + BIN + FS;
        ArrayList<String> paths = new ArrayList<String>();
        for (String executable : executables) {
            for (String extension : extensions) {
                String path = dir + executable + extension;
                paths.add(path);
            }
        }
        return paths;
    }
}

