/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.jenkins;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.kuali.maven.common.ResourceUtils;

public class UpdateSlaveAMIMojo
extends AbstractMojo {
    ResourceUtils utils = new ResourceUtils();
    private File configFile;
    private String newAmi;

    public void execute() throws MojoExecutionException {
        try {
            String oldContent = this.utils.read(this.configFile.getAbsolutePath());
            String open = "<hudson.plugins.ec2.SlaveTemplate>";
            String close = "</hudson.plugins.ec2.SlaveTemplate>";
            String slaveTemplate = StringUtils.substringBetween((String)oldContent, (String)open, (String)close);
            String oldAmi = StringUtils.substringBetween((String)slaveTemplate, (String)"<ami>", (String)"</ami>");
            String oldText = "<ami>" + oldAmi + "</ami>";
            String newText = "<ami>" + this.newAmi + "</ami>";
            String newContent = oldContent.replace(oldText, newText);
            File bakFile = new File(this.configFile.getAbsolutePath() + ".bak");
            File newFile = new File(this.configFile.getAbsolutePath() + ".new");
            this.getLog().info((CharSequence)("Old AMI: " + oldAmi));
            this.getLog().info((CharSequence)("New AMI: " + this.newAmi));
            this.getLog().info((CharSequence)("Backing up original to " + bakFile.getAbsolutePath()));
            this.getLog().info((CharSequence)("Rewriting " + this.configFile.getAbsolutePath()));
            this.getLog().info((CharSequence)("New file " + newFile.getAbsolutePath()));
            FileUtils.write((File)bakFile, (CharSequence)oldContent);
            FileUtils.write((File)newFile, (CharSequence)newContent);
            FileUtils.write((File)this.configFile, (CharSequence)newContent);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unexpected error", e);
        }
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public String getNewAmi() {
        return this.newAmi;
    }

    public void setNewAmi(String newAmi) {
        this.newAmi = newAmi;
    }
}

