/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.jenkins;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.kuali.maven.plugins.jenkins.helper.DirectoryFileFilter;
import org.kuali.maven.plugins.jenkins.helper.RsyncHelper;

public class SyncWorkspaceMojo
extends AbstractMojo {
    RsyncHelper helper = new RsyncHelper();
    private MavenProject project;
    private boolean excludeTarget;
    private String excludeTargetPattern;
    private boolean failOnError;
    private boolean compress;
    private boolean stats;
    private String ignoreCodes;
    private boolean verbose;
    private File excludesFile;
    private File basedir;
    private String source;
    private String destination;
    private String executable;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Src - " + this.source));
        this.getLog().info((CharSequence)("Dst - " + this.destination));
        this.getLog().info((CharSequence)("Exclude - " + this.excludeTarget));
        if (this.excludeTarget) {
            this.getLog().info((CharSequence)("Base Dir - " + this.basedir.getAbsolutePath()));
            this.getLog().info((CharSequence)("Exclude Pattern - " + this.excludeTargetPattern));
            this.getLog().info((CharSequence)("Excludes File - " + this.excludesFile));
        }
        this.prepareFileSystem();
        long start = System.currentTimeMillis();
        int exitValue = this.executeRsync();
        long elapsed = System.currentTimeMillis() - start;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(3);
        nf.setMinimumFractionDigits(3);
        this.getLog().info((CharSequence)("Sync time: " + nf.format((double)elapsed / 1000.0) + "s"));
        this.validateExitValue(exitValue);
    }

    protected List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-a");
        if (this.compress) {
            args.add("-z");
        }
        if (this.verbose) {
            args.add("-vv");
        }
        if (this.stats) {
            args.add("--stats");
        }
        args.add("--delete");
        if (this.excludeTarget) {
            args.add("--delete-excluded");
            args.add("--exclude-from");
            args.add(this.excludesFile.getAbsolutePath());
        }
        args.add(this.source);
        args.add(this.destination);
        return args;
    }

    protected Commandline getCommandLine() {
        Commandline cl = new Commandline();
        cl.setExecutable(this.executable);
        cl.setWorkingDirectory(this.basedir);
        this.addArgs(cl, this.getArgs());
        return cl;
    }

    protected void addArgs(Commandline cl, List<String> args) {
        if (args == null || args.size() == 0) {
            return;
        }
        for (String arg : args) {
            cl.createArg().setValue(arg);
        }
    }

    protected int executeRsync() throws MojoExecutionException {
        DefaultConsumer stdout = new DefaultConsumer();
        DefaultConsumer stderr = new DefaultConsumer();
        Commandline cl = this.getCommandLine();
        this.getLog().info((CharSequence)cl.toString());
        try {
            return CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error executing " + this.executable, (Exception)((Object)e));
        }
    }

    protected List<Integer> getAllowedCodes() {
        ArrayList<Integer> codes = new ArrayList<Integer>();
        codes.add(0);
        if (!StringUtils.isBlank((String)this.ignoreCodes)) {
            String[] tokens;
            for (String token : tokens = StringUtils.split((String)this.ignoreCodes, (String)",")) {
                codes.add(new Integer(token.trim()));
            }
        }
        return codes;
    }

    protected boolean isFail(int exitValue) {
        List<Integer> codes = this.getAllowedCodes();
        for (Integer code : codes) {
            if (exitValue != code) continue;
            return false;
        }
        return this.failOnError;
    }

    protected void validateExitValue(int exitValue) throws MojoExecutionException {
        if (this.isFail(exitValue)) {
            throw new MojoExecutionException("Non-zero exit value - " + exitValue);
        }
        if (exitValue != 0) {
            this.getLog().info((CharSequence)("Ignoring non-zero exit value - " + exitValue));
        }
    }

    protected void prepareFileSystem() throws MojoExecutionException {
        if (!this.excludeTarget) {
            return;
        }
        try {
            FileUtils.touch((File)this.excludesFile);
            DirectoryFileFilter dff = new DirectoryFileFilter();
            List<File> excludeDirs = this.helper.getMatchingDirs(this.basedir, this.excludeTargetPattern, dff);
            List<String> excludes = this.helper.getExcludesList(this.basedir, excludeDirs);
            int size = excludes.size();
            if (size == 1) {
                this.getLog().info((CharSequence)("Excluding " + excludes.size() + " directory"));
            } else {
                this.getLog().info((CharSequence)("Excluding " + excludes.size() + " directories"));
            }
            FileUtils.writeLines((File)this.excludesFile, excludes);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error preparing file system", (Exception)e);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isExcludeTarget() {
        return this.excludeTarget;
    }

    public void setExcludeTarget(boolean excludeTarget) {
        this.excludeTarget = excludeTarget;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public File getExcludesFile() {
        return this.excludesFile;
    }

    public void setExcludesFile(File excludesFile) {
        this.excludesFile = excludesFile;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public String getExcludeTargetPattern() {
        return this.excludeTargetPattern;
    }

    public void setExcludeTargetPattern(String excludeTargetPattern) {
        this.excludeTargetPattern = excludeTargetPattern;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getIgnoreCodes() {
        return this.ignoreCodes;
    }

    public void setIgnoreCodes(String ignoreCodes) {
        this.ignoreCodes = ignoreCodes;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isStats() {
        return this.stats;
    }

    public void setStats(boolean stats) {
        this.stats = stats;
    }
}

