/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.externals;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.kuali.maven.plugins.externals.MojoHelper;
import org.kuali.maven.plugins.externals.POMUtils;

public class FormatPomsMojo
extends AbstractMojo {
    MojoHelper helper = MojoHelper.getInstance();
    POMUtils pomUtils = new POMUtils();
    private String pom;
    private String ignoreDirectories;
    private File basedir;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        List<File> poms = this.helper.getPoms(this.basedir, this.pom, this.ignoreDirectories);
        int count = 0;
        for (File pom : poms) {
            String formattedXML;
            String xml = this.helper.read(pom);
            if (xml.equals(formattedXML = this.pomUtils.format(xml))) continue;
            ++count;
            this.helper.write(pom, formattedXML);
            this.getLog().info((CharSequence)("Formatting applied to " + pom.getAbsolutePath()));
        }
        this.getLog().info((CharSequence)("Formatted " + count + " poms"));
    }

    public String getPom() {
        return this.pom;
    }

    public void setPom(String pom) {
        this.pom = pom;
    }

    public String getIgnoreDirectories() {
        return this.ignoreDirectories;
    }

    public void setIgnoreDirectories(String ignoreDirectories) {
        this.ignoreDirectories = ignoreDirectories;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }
}

