/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.ec2.state;

import com.amazonaws.services.ec2.model.Instance;
import org.kuali.maven.ec2.EC2Utils;
import org.kuali.maven.ec2.state.StateRetriever;
import org.springframework.util.Assert;

public class InstanceStateRetriever
implements StateRetriever {
    EC2Utils ec2Utils;
    String instanceId;

    public InstanceStateRetriever() {
        this(null, null);
    }

    public InstanceStateRetriever(EC2Utils ec2Utils, String instanceId) {
        this.ec2Utils = ec2Utils;
        this.instanceId = instanceId;
    }

    @Override
    public String getState() {
        Assert.notNull((Object)this.ec2Utils);
        Assert.notNull((Object)this.instanceId);
        Instance i = this.ec2Utils.getEC2Instance(this.instanceId);
        return i.getState().getName();
    }

    public EC2Utils getEc2Utils() {
        return this.ec2Utils;
    }

    public void setEc2Utils(EC2Utils ec2Utils) {
        this.ec2Utils = ec2Utils;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }
}

